/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 70574 $
 */

/*
 * Class: Legato.Util.Tag
 * This class represents a generic tag with string key and value (value is optional).
 */
Legato.Util.Tag = Legato.Lang.Class( {

  /*
   * Property: name
   * 
   * {String} Name of the tag
   */
  name :null,

  /*
   * Property: value
   * 
   * {String} Value of the tag
   */
  value :null,

  /*
   * Constructor: Legato.Util.Tag Create a new tag instance
   * 
   * Parameters: name - {String} The name of the tag value - {String} The value
   * of the tag
   * 
   * Returns: An instance of Legato.Util.Tag
   */
  initialize : function(name, value) {
    Legato.Util.Ensure.ensureString(name);
    this.name = name;
    if (Legato.Lang.ObjectUtils.exists(value)) {
      Legato.Util.Ensure.ensureString(value);
      this.value = value;
    } else {
      this.value = null;
    }
  },

  /*
   * Method: toString Cast this object into a string.
   * 
   * Returns: {String} The string representation of this tag.
   */
  toString : function() {
    return '[' + this.name + (this.value === null ? '' : '=' + this.value)
        + ']';
  },

  /*
   * Method: equals Determines whether one tag is equivalent to another.
   * 
   * Parameters: tag - {<Legato.Util.Tag>}
   * 
   * Returns: {Boolean} The tag passed in as parameter is equal to this.
   */
  equals : function(tag) {
    return (tag !== null) && (this.name == tag.name && this.value == tag.value);
  },

  CLASS_NAME :"Legato.Util.Tag"
});
