/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: oll:OSM
 * 
 * Supports OpenStreetMap tiles.
 * 
 * Inherits from:
 * - {<oll:OSM>}
 * 
 * See also:
 * - <oll> namespace
 * - {<OpenLayers.Layer.XYZ}}
 * - {<OpenLayers.Layer.OSM}}
 * - <OL:XYZ> layer type
 * - <OL:OSM> layer type
 */
OpenLayers.Layer.OSM.Bean = OpenLayers.Layer.XYZ.Bean.Extend(
		'OpenLayers.Layer.OSM',
		//
		Legato.OpenLayers.Layer.QName('OSM'), {
			//
			_constructor : OpenLayers.Layer.OSM,
			options : {
				/**
				 * Element: sphericalMercator
				 * {Boolean} Whether the tile extents should be set to the defaults for 
				 * spherical mercator. Useful for things like OpenStreetMap.
				 * Default is true.
				 */
				sphericalMercator : Legato.Lang.Boolean
			}
		});

/**
 * Layer type: OL:OSM
 * 
 * See also:
 * - {<oll:XYZ>}
 * - {<oll:OSM>}
 * - {<OpenLayers.Layer.XYZ>}
 * - {<OpenLayers.Layer.OSM>}
 * 
 * Example:
 * (start code)
 * <Layer queryable="0" hidden="0">                                                                       
 *   <Server service="OL:OSM" version="1.1.1" title="OL:OSM">                                           
 *     <OnlineResource xlink:type="simple" xlink:href="http://tile.openstreetmap.org/${z}/${x}/${y}.png" />
 *   </Server>                                                                                            
 *   <Name>OpenStreetMap</Name>                                                                              
 *   <Title>OpenStreetMap</Title>                                                                           
 * </Layer>                                                                                               
 * (end)
 */
OpenLayers.Layer.OSM.LayerFactory = Legato.Lang.Class(
//
Legato.Format.ExtendedWMC.LayerFactory,
//
{
	layerType : OpenLayers.Layer.OSM.Bean
});

Legato.Format.ExtendedWMC.registerDefaultLayerFactory('OL:OSM',
		new OpenLayers.Layer.OSM.LayerFactory());