/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: olc:MousePosition
 * 
 * Inherits from:
 * - {<olc:Control>}
 * 
 * See also:
 * - <olc> namespace
 * - {<OpenLayers.Control.MousePosition>}
 */
OpenLayers.Control.MousePosition.Bean = OpenLayers.Control.Bean.Extend(
		'OpenLayers.Control.MousePosition', Legato.OpenLayers.Control
				.QName('MousePosition'), {
			_constructor : OpenLayers.Control.MousePosition,
			options : {
				/**
				 * Element: element
				 * {DOMElement}
				 */
				element : Legato.Lang.Element,
				/**
				 * Element: prefix
				 * {String}
				 */
				prefix : Legato.Lang.String,
				/**
				 * Element: separator
				 * {String}
				 */
				separator : Legato.Lang.String,
				/**
				 * Element: suffix
				 * {String}
				 */
				suffix : Legato.Lang.String,
				/**
				 * Element: numDigits
				 * {Integer}
				 */
				numDigits : Legato.Lang.Integer,
				/**
				 * Element: granularity
				 * {Integer}
				 */
				granularity : Legato.Lang.Integer,
				/**
				 * Element: displayProjection
				 * {<ol:Projection>}
				 */
				displayProjection : OpenLayers.Projection.Bean
			}
		});