/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 91043 $
 */

/**
 * Class: Legato.Format.ExtendedWMC.Model
 * Models an OGC ViewContext. Important: not all attributes are added,
 * only those that are actually used in Legato, or
 * which are required according to the OGC WMC standard
 */
Legato.Format.ExtendedWMC.Model = OpenLayers.Class({

  /**
   * constructor
   */
  initialize : function() {
    this.layerList = [];
  },

  toString : function() {
    return this.CLASS_NAME;
  },

  /**
   * Property: id
   * {String} id of the view context (required)
   */
  id: null,

  /**
   * Property: version
   * {String} version of the view context (required)
   */
  version: null,

  /**
   * Property: boundingBox
   * {<Legato.Format.ExtendedWMC.Model.BoundingBox>} the geographic extent that should be presented by the client (required)
   */
  boundingBox: null,

  /**
   * Property: window
   * {<Legato.Format.ExtendedWMC.Model.Window>} the size in pixels of the map the Context document describes (optional)
   */
  window: null,

  /**
   * Property: title
   * {String} contains a human readable title of the Context (required)
   */
  title: null,

  /**
   * Property: extensions
   * {<Legato.Format.ExtendedWMC.Model.Extensions>} Non-standard extensions
   */
  extensions: null,

  /**
   * Property: layerList
   * {Array(<Legato.Format.ExtendedWMC.Model.Layer>)} list of all layers to build a required view (map)
   */
  layerList: null,

  CLASS_NAME : 'Legato.Format.ExtendedWMC.Model'
});

/**
 * Class: Legato.Format.ExtendedWMC.Model.BoundingBox
 * Bounding box with geo reference system
 */
Legato.Format.ExtendedWMC.Model.BoundingBox = OpenLayers.Class({

  /**
   * constructor
   */
  initialize : function() {

    //do nothing

  },

  toString : function() {
    return this.CLASS_NAME;
  },

  /**
   * Property: SRS
   * {String} spatial reference system (required)
   */
  SRS: null,

  /**
   * Property: bounds
   * {OpenLayers.Bounds} the bounds of the bounding box (left, bottom, right, top)
   */
  bounds: null,

  CLASS_NAME : 'Legato.Format.ExtendedWMC.Model.BoundingBox'
});

/**
 * Class: Legato.Format.ExtendedWMC.Model.Window
 * Map Window information
 */
Legato.Format.ExtendedWMC.Model.Window = OpenLayers.Class({

  /**
   * constructor
   */
  initialize : function() {
    //do nothing

  },

  toString : function() {
    return this.CLASS_NAME;
  },

  /**
   * Property: width
   * {Integer} the width in pixels (required)
   */
  width: null,

  /**
   * Property: height
   * {Integer} the height in pixels (required)
   */
  height: null,

  CLASS_NAME : 'Legato.Format.ExtendedWMC.Model.Window'
});

/**
 * Class: Legato.Format.ExtendedWMC.Model.Extensions
 * Holds non-standard extensions for the whole WMC model
 */
Legato.Format.ExtendedWMC.Model.Extensions = OpenLayers.Class({

  initialize : function() {

   //do nothing

  },

  toString : function() {
    return this.CLASS_NAME;
  },

  /**
   * Property: legato
   * {<Legato.Format.ExtendedWMC.Model.Extensions.Legato>} Extensions specific for Legato
   */
  legato : null,

  CLASS_NAME : 'Legato.Format.ExtendedWMC.Model.Extensions'
});


/**
 * Class: Legato.Format.ExtendedWMC.Model.Extensions.Legato
 * Non-standard legato extensions
 */
Legato.Format.ExtendedWMC.Model.Extensions.Legato = OpenLayers.Class({

  initialize : function() {
   this.capabilities = [];
  },

  toString : function() {
    return this.CLASS_NAME;
  },

  /**
   * Property: capabilities
   * {Array(String)} A list of capabilities URIs
   */
  capabilities: null,

  /**
   * Property: minScale
   * {Float} The minimum scale where the layer should be displayed (optional)
   */
  minScale: null,

  /**
   * Property: maxScale
   * {Float} The maximum scale where the layer should be displayed (optional)
   */
  maxScale: null,

  CLASS_NAME : 'Legato.Format.ExtendedWMC.Model.Extensions.Legato'
});


/**
 * Class: Legato.Format.ExtendedWMC.Model.Layer
 * Bean to store layer information
 */
Legato.Format.ExtendedWMC.Model.Layer = OpenLayers.Class({

  /**
   * constructor
   */
  initialize : function() {
    this.formatList = [];
    this.styleList = [];
    this.extension = {};
    this.srs = [];
  },

  toString : function() {
    result = this.CLASS_NAME;
    result += (this.name) ? ': ' + this.name : '';
    return result;
  },

  /**
   * Property: hidden
   * {Boolean} contains true if the layer should be hidden in the client result map (required)
   */
  hidden : null,

  /**
   * Property: queryable
   * {Boolean} contains true if the layer is set queryable (required)
   */
  queryable : null,

  /**
   * Property: server
   * {<Legato.Format.ExtendedWMC.Model.Layer.Server>} defining the service from which the named Layer may be requested
   */
  server : null,

  /**
   * Property: name
   * {String} The name of the selected layer (required)
   */
  name : null,

  /**
   * Property: title
   * {String} The title of the selected layer (required)
   */
  title : null,

  /**
   * Property: layerAbstract
   * {String} The abstract of the selected layer (optional)
   */
  layerAbstract : null,

  /**
   * Property: minScaleDenominator
   * {Float} The denominator (1:X) part of minimum scale where the layer should be displayed (optional)
   */
  minScaleDenominator: null,

  /**
   * Property: maxScaleDenominator
   * {Float} The denominator (1:X) part of maximum scale where the layer should be displayed (optional)
   */
  maxScaleDenominator: null,

  /**
   * Property: srs
   * {Array(String)} coordinate systems of the layer
   */
  srs : null,

  /**
   * Property: formatList
   * {Array(String)} A list of strings specifying the available image format for this layer. Image formats
   * should be expressed with MIME types as described in WMS 1.1.1 Specification.
   */
  formatList : null,

  /**
   * Property: styleList
   * {Array(Legato.Format.ExtendedWMC.Model.Layer.Style)} A list of styles.
   */
  styleList : null,

  /**
   * Property: currentFormat
   * {String} The currently selected format (included also in the formatList)
   */
  currentFormat : null,

  /**
   * Property: extension
   * A map of layer-specific extensions
   */
  extension : null,

  CLASS_NAME : 'Legato.Format.ExtendedWMC.Model.Layer'
});

/**
 * Class: Legato.Format.ExtendedWMC.Model.Layer.Server
 * Server information
 */
Legato.Format.ExtendedWMC.Model.Layer.Server = OpenLayers.Class({

  /**
   * constructor
   */
  initialize : function() {
    //do nothing
  },

  toString : function() {
    return this.CLASS_NAME;
  },

  /**
   * Property: service
   * {String} the type of the service according to OGC interfaces, such as WMS, WFS. (required)
   */
  service : null,

  /**
   * Property: version
   * {String} Version number of the OGC interface specification which corresponds to the service (required)
   */
  version : null,

  /**
   * Property: title
   * {String} the title of the service (extracted from the Capabilities by the Context document creator) (optional)
   */
  title : null,

  /**
   * Property: onlineResource
   * {String} the link (URI) to the online resource (required)
   */
  onlineResource : null,

  CLASS_NAME : 'Legato.Format.ExtendedWMC.Model.Layer.Server'
});


/**
 * Class: Legato.Format.ExtendedWMC.Model.Layer.Style
 * Style information.
 */
Legato.Format.ExtendedWMC.Model.Layer.Style = OpenLayers.Class({

  /**
   * constructor
   */
  initialize : function() {
    //do nothing
  },

  toString : function() {
    return this.CLASS_NAME;
  },

  /**
   * Property: name
   * {String} name of the style.
   */
  name : null,

  /**
   * Property: title of the style
   * {String} title of the style.
   */
  title : null,

  /**
   * Property: abstract of the style
   * {String} abstract of the style.
   */
  styleAbstract: null,

  /**
   * Property: abstract of the style
   * {String} abstract of the style.
   */
  legendURL: null,

  CLASS_NAME : 'Legato.Format.ExtendedWMC.Model.Layer.Style'
});