/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: Legato.OverviewMap
 * Represents an overview map
 *
 * Inherits from:
 *  - <OpenLayers.Map>
 */
Legato.OverviewMap =
  OpenLayers.Class(OpenLayers.Map, {

    Z_INDEX_BASE: {
      BaseLayer: 2100,
      Overlay: 2325,
      Feature: 2725,
      Popup: 2750,
      Control: 3000
    },

    CLASS_NAME: 'Legato.OverviewMap'
});


/**
 * Structure: l:OverviewMap
 * XML based config for a <Legato.OverviewMap>.
 *
 * See Also:
 * - <QName>
 * - <PREFIX>
 * - <Legato.Beans.BeanFactory>
 *
 * A valid example could be
 *
 * (start code)
 * <l:OverviewMap foo="bar"/>
 * (end)
 *
 * For detailed informations have a look at the <OpenLayers.Map> documentation.
 */
Legato.OverviewMap.Bean = OpenLayers.Map.Bean.Extend('Legato.OverviewMap',
    //
    Legato.QName('OverviewMap'),
    //
    {
      factoryFunction: function(id, options)
      {
        if (!Legato.Lang.ObjectUtils.exists(options))
        {
          options = {};
        }
        if (!Legato.Lang.ObjectUtils.exists(options.controls))
        {
          options.controls = [];
        }
        if (!Legato.Lang.ObjectUtils.exists(options.theme))
        {
          options.theme = null;
        }
        return new Legato.OverviewMap(id, options);
      }
    });



