/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.NavigationHistoryPrevious = OpenLayers.Class(Legato.Control.AbstractNavigationHistoryButton, {
  /**
   * Property: title  
   * {string}  This property is used for showing a tooltip over the  
   * NavigationHistoryPrevious control. Default value is "Previous".  
   */ 
  title: 'Previous',

  /**
   * Constructor: OpenLayers.Control.NavigationHistoryPrevious
   * 
   * Parameters: 
   * history - {Legato.Control.NavigationHistory}
   * options - {Object}
   */
  initialize: function(history, options) {
    Legato.Control.AbstractNavigationHistoryButton.prototype.initialize.apply(this, [history, options]);
    this.history.events.register("previousChange", this, this.onPreviousChange);
  },
  
  /**
   * Method: onPreviousChange
   * Called when the previous history stack changes.
   *
   * Parameters:
   * state - {Object} An object representing the state to be restored
   *     if previous is triggered again or null if no previous states remain.
   * length - {Integer} The number of remaining previous states that can
   *     be restored.
   */
  onPreviousChange: function(event) {
      var state = event.state;
      if(state && !this.active) {
          this.activate();
      } else if(!state && this.active) {
          this.deactivate();
      }
  },

  /**
   * APIMethod: trigger
   * Restore the previous state.  If no items are in the previous history
   *     stack, this has no effect.
   *
   * Returns:
   * {Object} Item representing state that was restored.  Undefined if no
   *     items are in the previous history stack.
   */
  trigger: function() {
      var current = this.history.previousStack.shift();
      var state = this.history.previousStack.shift();
      if(!Legato.Lang.ObjectUtils.isUndefined(state)) {
          this.history.nextStack.unshift(current);
          this.history.previousStack.unshift(state);
          this.history.restoring = true;
          this.history.restore(state);
          this.history.restoring = false;
          this.history.onNextChange(this.history.nextStack[0], this.history.nextStack.length);
          this.history.onPreviousChange(
              this.history.previousStack[1], this.history.previousStack.length - 1
          );
      } else {
          this.history.previousStack.unshift(current);
      }
      return state;
  },
  
  CLASS_NAME: "Legato.Control.NavigationHistoryPrevious"

});

/**
 * Structure: lc:NavigationHistoryPrevious XML based config for a <Legato.Control.NavigationHistoryPrevious>.
 * 
 * See Also: - <Legato.Control> - <Legato.Beans.BeanFactory> - <QName>
 * 
 * A valid config example for a NavigationHistoryPrevious would be:
 * (start code)
 * <lc:NavigationHistoryPrevious title="Tooltip for previous">
 *   <history>
 *     <lb:Reference target="NavigationHistory" />
 *   </history>
 * </lc:NavigationHistoryPrevious>
 * (end)
 */
Legato.Control.NavigationHistoryPrevious.Bean = Legato.Control.Bean.Extend(
    'Legato.Control.NavigationHistoryPrevious',
    Legato.Control.QName('NavigationHistoryPrevious'),
    {
      factoryFunction : function(history, options)
      {
        return new Legato.Control.NavigationHistoryPrevious(history, options);
      },
      constructorArguments : {
        history : Legato.Control.NavigationHistory.Bean
      },
      constructorOrder : [ 'history' ]
    });