/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Rev: 72369 $
 * @base Legato.Control
 * @requires Legato/Control.js
 */

/**
 * Class: ControlFunction
 *
 * Inherits from: - <Legato.Control>
 */
Legato.Control.ControlFunction = OpenLayers.Class(Legato.Control,
{
  /**
   * Property: type
   * {OpenLayers.Control.TYPE}
   */
  type: OpenLayers.Control.TYPE_BUTTON,

  /**
   * Constructor: Legato.Control.ControlFunction
   * Create a new control function control displayed as a button. If clicked the given callback
   * method will been executed and the current map will been passed as argument.
   *
   * Parameters:
   * options - {Object} A Hashmap containing option parameters for this control
   *
   * The following keys are supported for an observer element
   * - callback {function} the callback method wich will been executed if control has been clicked
   *
   */
  initialize : function(options) {
    Legato.Control.prototype.initialize.apply(this, arguments);
    Legato.Util.Ensure.ensureFunction(this.callback,
        'To use ' + this.CLASS_NAME + ' you must specify a callback function.');
  },

  /** Function: trigger
   * Invoked when the control is clicked
   */
  trigger : function() {
    this.callback(this.map);
  },

  CLASS_NAME: 'Legato.Control.ControlFunction'
});

/**
 * Structure: lc:ControlFunction
 * XML based config for a <Legato.Control.ControlFunction>.
 *
 * See Also:
 * - <Legato.Control>
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a ControlFunction would be:
 * (start code)
 * <lc:ControlFunction />
 * (end)
 */
Legato.Control.ControlFunction.Bean = Legato.Control.Bean.Extend(

  'Legato.Control.ControlFunction',

  /**
   * Property: QName
   * The qualified name for this control. Needed by XML config to instantiate it.
   */
  Legato.Control.QName('ControlFunction'),
  {
    _constructor: Legato.Control.ControlFunction,
    options:
    {
      callback: Legato.Lang.Function,
      displayClass: Legato.Lang.String
    }
  }
);
