/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: oll:GeoRSS
 *
 * Inherits from:
 * - {<oll:Markers>}
 *
 * See also:
 * - <oll> namespace
 * - {<OpenLayers.Layer.GeoRSS>}
 */
OpenLayers.Layer.GeoRSS.Bean = OpenLayers.Layer.Markers.Bean.Extend(
    'OpenLayers.Layer.GeoRSS',
    //
    Legato.OpenLayers.Layer.QName('GeoRSS'),
    //
    {
      factoryFunction : function(name, url, options) {
        if (!Legato.Lang.ObjectUtils.exists(options)) {
          options = {};
        }

        options.isBaseLayer = false;

        return new OpenLayers.Layer.GeoRSS(name, url, options);
      },
      constructorArguments : {
        /**
         * Element: name
         * {String}
         */
        name : Legato.Lang.String,
        /**
         * Element: url
         * {String}
         */
        url : Legato.Lang.String
      },
      options : {

        /**
         * Element: icon
         * {<ol:Icon>}
         */
        icon : Legato.Beans.Object,

        /**
         * Element: popupSize
         * {<ol:Size>}
         */
        popupSize : OpenLayers.Size.Bean,

        /**
         * Element: useFeedTitle
         * {Boolean}
         */
        useFeedTitle : Legato.Lang.Boolean,

        /**
         * Element: formatOptions
         */
        formatOptions : Legato.Beans.Object
      },
      constructorOrder : [ 'name', 'url' ]
    });

/**
 * Layer type: OL:GeoRSS
 *
 * See also:
 * - {<oll:GeoRSS>}
 * - {<OpenLayers.Layer.GeoRSS>}
 *
 * WMC example:
 * (start code)
 * <Layer hidden="0" queryable="0">
 *   <Server service="OL:GeoRSS" title="OL:GeoRSS">
 *     <OnlineResource xlink:type="simple" xlink:href="georss.xml" />
 *   </Server>
 *   <Name>GeoRSS</Name>
 *   <Title>GeoRSS Layer</Title>
 *   <Extension>
 *     <le:Extension xmlns="">
 *       <popupSize>
 *         <ol:Size w="200" h="100"/>
 *       </popupSize>
 *       <icon>
 *         <ol:Icon url="pin.png">
 *           <offset>
 *             <ol:Pixel x="10" y="20"/>
 *           </offset>
 *           <size>
 *             <ol:Size w="30" h="40"/>
 *           </size>
 *         </ol:Icon>
 *       </icon>
 *     </le:Extension>
 *   </Extension>
 * </Layer>
 * (end)
 */
OpenLayers.Layer.GeoRSS.LayerFactory = Legato.Lang.Class(
//
Legato.Format.ExtendedWMC.LayerFactory,
//
{
  layerType : OpenLayers.Layer.GeoRSS.Bean
});

Legato.Format.ExtendedWMC.registerDefaultLayerFactory('OL:GeoRSS',
    new OpenLayers.Layer.GeoRSS.LayerFactory());