/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Layer.VectorUpdater = OpenLayers.Class( {
  url :null,
  params :null,
  layer :null,
  format :null,
  onSuccess : function(request) {
  },
  onFailure : function(request) {
    OpenLayers.Console.error(request);
  },
  initialize : function(options) {
    OpenLayers.Util.extend(this, options);
    var url = options.url;
    if (Legato.Lang.ObjectUtils.isString(url)) {
      var questionMarkIndex = url.indexOf('?');
      if (questionMarkIndex > 0) {
        this.url = url.substring(0, questionMarkIndex);
        this.params = OpenLayers.Util.getParameters(url);
      } else {
        this.url = url;
        this.params = null;
      }
      
      if (!Legato.Lang.ObjectUtils.exists(this.format)){
        this.format = new Legato.Format.GML3();
      }
      var layer = options.layer;
      if (Legato.Lang.ObjectUtils.exists(layer)
          && Legato.Lang.ObjectUtils.exists(layer.events)) {
        this.layer = layer;
        this.layer.events.on( {
          'featuresadded' :this.update,
          'featuresremoved' :this.update,
          'featuremodified' :this.update,
          scope :this
        });
      }
    } else {
      this.url = null;
      this.params = null;
    }
  },
  destroy : function() {
    if (Legato.Lang.ObjectUtils.exists(this.layer)) {
      this.layer.events.un( {
        'featuresadded' :this.update,
        'featuresremoved' :this.update,
        'featuremodified' :this.update,
        scope :this
      });
    }
    this.layer = null;
    this.url = null;
    this.params = null;
  },
  update : function() {
    var features = this.layer.features;
    if (Legato.Lang.ObjectUtils.isNotEmptyArray(features)) {
      var data = this.format.write(features);
      var request = new OpenLayers.Request.POST( {
        url :this.url,
        params :this.params,
        data :data,
        success :this.onSuccess,
        failure :this.onFailure,
        scope :this
      });
    }
  },
  CLASS_NAME :'Legato.Layer.VectorUpdater'
});
Legato.Layer.VectorUpdater.Bean = Legato.Beans.Object.Extend(
    'Legato.Layer.VectorUpdater',

    Legato.Layer.QName('VectorUpdater'), {
      _constructor :Legato.Layer.VectorUpdater,
      options : {
        url :Legato.Lang.String,
        format :Legato.Beans.Object,
        layer :Legato.Beans.Object
      }
    });
