/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Handler.Polygon = OpenLayers.Class(OpenLayers.Handler.Polygon, {
  initialize: function(control, callbacks, options) {
    var opts = options;
    if (!options) {
      opts = {};
    }
    if (!opts.layerOptions) {
      opts.layerOptions = {};
    }
    opts.layerOptions.legatoIgnore = true;
    OpenLayers.Handler.Polygon.prototype.initialize.apply(this, [control, callbacks, opts]);
  },
  mousedown : function(evt) {
    if (this.drawing && evt.ctrlKey) {
      OpenLayers.Handler.Polygon.prototype.mousedown.apply(this, arguments);
      this.dblclick(evt);
      return false;
    } else {
      return OpenLayers.Handler.Polygon.prototype.mousedown.apply(this, arguments);
    }
  },
  geometryClone : function() {
    var originalGeometry = this.polygon && this.polygon.geometry;
    if (originalGeometry) {
      var originalGeometryId = originalGeometry.id;
      originalGeometry.id = OpenLayers.Util.createUniqueID(originalGeometry.CLASS_NAME+ "_");
      var clonedGeometry = originalGeometry.clone();
      clonedGeometry.id = originalGeometryId;
      this.polygon.geometry = clonedGeometry;
      if (this.multi) {
        return new OpenLayers.Geometry.MultiPolygon([ originalGeometry ]);
      } else {
        return originalGeometry;
      }
    }
    return originalGeometry;
  },
  CLASS_NAME : "Legato.Handler.Polygon"
});