/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Rev: 72369 $
 * @base Legato.Control.Legend.Plugin
 * @requires Legato/Control.js
 * @requires Legato/Legend.js
 * @requires Legato/Legend/Plugin.js
 */

/**
 * Class: Legato.Control.Legend.Plugin.Layer
 */
Legato.Control.Legend.Plugin.Layer = OpenLayers
		.Class(
				Legato.Control.Legend.Plugin,
				{

					/**
					 * Property: plugins {Array}
					 */
					plugins : null,

					/**
					 * Function: create
					 */
					create : function() {
						Legato.Control.Legend.Plugin.prototype.create.apply(
								this, arguments);
						for ( var index = 0; index < this.plugins.length; index++) {
							var pluginDiv = this.plugins[index].draw();
							if (Legato.Lang.ObjectUtils.exists(pluginDiv)) {
								this.div.appendChild(pluginDiv);
							}
						}
						// Break after all the plugins
						var br = document.createElement('div');
						br.style.clear = 'both';
						this.div.appendChild(br);
					},

					/**
					 * Function: update
					 */
					update : function() {
						this.div.className = this.displayClass
								+ ' '
								+ (this.layer.isBaseLayer ? this.displayClass
										+ 'BaseLayer' : this.displayClass
										+ 'Overlay')
								+ ' '
								+ (this.layer.selected ? this.displayClass
										+ 'Selected' : this.displayClass
										+ 'Deselected');
					},

					/**
					 * Function: onclick
					 */
					onclick : function(event) {
						if (Legato.Lang.ObjectUtils
								.isFalse(this.layer.selected)) {
							this.map.selectLayer(this.layer);
						} else if (Legato.Lang.ObjectUtils
								.isTrue(this.layer.selected)) {
							this.map.deselectLayer(this.layer);
						}
						if (Legato.Lang.ObjectUtils.exists(event)) {
							OpenLayers.Event.stop(event, true);
						}
					},

					/**
					 * Function: afterSetup
					 */
					afterSetup : function() {
						if (Legato.Lang.ObjectUtils
								.isFunction(this.map.selectLayer)) {
							this.div.onclick = OpenLayers.Function
									.bindAsEventListener(this.onclick, this);
						}
						this.map.events.on({
							'legato.selectlayer' : this.update,
							'legato.deselectlayer' : this.update,
							scope : this
						});
					},

					/**
					 * Function: beforeDestroyed
					 */
					beforeDestroyed : function() {
						this.div.onclick = null;
						this.map.events.un({
							'legato.selectlayer' : this.update,
							'legato.deselectlayer' : this.update,
							scope : this
						});
					},

					/**
					 * Function: destroy
					 */
					destroy : function() {
						for ( var index = 0; index < this.plugins.length; index++) {
							this.plugins[index].destroy();
						}
						this.plugins = null;
						Legato.Control.Legend.Plugin.prototype.destroy.apply(
								this, arguments);
					},

					CLASS_NAME : 'Legato.Control.Legend.Plugin.Layer'
				});

/**
 * Class: Legato.Control.Legend.Plugin.Layer.Factory Factory class wich is able
 * to create a <Legato.Control.Legend.Plugin.Layer> instance.
 */
Legato.Control.Legend.Plugin.Layer.Factory = OpenLayers
		.Class(Legato.Control.Legend.Plugin.Factory,
				{
					/**
					 * Function: create Factory method for creating a
					 * <Legato.Control.Legend.Plugin.Layer> instance.
					 */
					create : function(layer, plugins) {
						var pluginOptions = OpenLayers.Util.extend({},
								this.pluginOptions);
						pluginOptions.plugins = Legato.Lang.ObjectUtils
								.exists(plugins) ? plugins : [];
						return new Legato.Control.Legend.Plugin.Layer(layer,
								pluginOptions);
					},
					CLASS_NAME : 'Legato.Control.Legend.Plugin.Layer.Factory'
				});

/**
 * Component: llp:Layer
 * 
 * Inherits from:
 * - <llp:Plugin>
 * 
 * See Also:
 * - <llp> namespace
 * - {<Legato.Control.Legend.Plugin.Layer>}
 *  
 * Configuration example:
 * (start code)
 * <llp:Layer>
 *   <displayClass>Foo</displayClass>
 * </llp:Layer>
 * (end)
 */
Legato.Control.Legend.Plugin.Layer.Bean = Legato.Control.Legend.Plugin.Bean
		.Extend('Legato.Control.Legend.Plugin.Layer.Factory',

		Legato.Control.Legend.Plugin.QName('Layer'), {
			_constructor : Legato.Control.Legend.Plugin.Layer.Factory
		});