/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Util.EventListener = OpenLayers.Class( {
  events :null,
  types :null,
  scope :null,
  callback :null,
  initialize : function(target, types, scope, callback) {
    this.events = target.events;
    this.types = types;
    this.callback = callback;

    for ( var index = 0; index < this.types.length; index++) {
      var type = this.types[index];
      this.events.register(type, null, this.callback);
    }
  },

  destroy : function() {
    for ( var index = 0; index < this.types.length; index++) {
      var type = this.types[index];
      this.events.unregister(type, null, this.callback);
    }
  },

  CLASS_NAME :'Legato.Util.EventListener'
});

Legato.Util.EventListener.Bean = Legato.Beans.Object.Extend(

'Legato.Util.EventListener',

Legato.Util.QName('EventListener'), {
  _constructor :Legato.Util.EventListener,
  constructorArguments : {
    target :Legato.Beans.Object,
    types :Legato.Lang['String[]'],
    scope :Legato.Beans.Object,
    callback :Legato.Lang.Function
  },
  constructorOrder : [ 'target', 'types', 'scope', 'callback' ]
});
