/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Lang.List = Legato.Lang.Class(Legato.Lang.AnyType, {
  elementType :null,
  isList :true,
  isInstance : function(value) {
    /* TODO ensure correct element types */
    return (value instanceof Array);
  },
  initialize : function(elementType) {
    this.elementType = elementType;
    this.typeName = elementType.typeName + '[]';
    if (elementType.fromString)
    {
      this.fromString = function(value, beanFactory) {
        if ((typeof value) != 'string') {
          throw new Error('Argument is not a string.');
        } else {
          return this.fromStringSafe(value, beanFactory);
        }
      };
      this.fromStringSafe = function(value, beanFactory) {
        var result = [];
        if (value.length !== 0) {
          var strings = value.split(',');
          for ( var index = 0; index < strings.length; index++) {
            var string = strings[index];
            /* TODO trim */
            result[index] = this.elementType.fromString(string, beanFactory);
          }
        }
        return result;
      };
    }
  }
});