/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
* A control that keeps the height of its div synchronized with the height
* of the map div
*/
Legato.Control.SyncMapDivSize = OpenLayers.Class(OpenLayers.Control, {

  /**
   * Property: syncHeight
   * {Boolean} Sets whether the height should be synced
   */
  syncHeight: false,

  /**
   * Property: syncWidth
   * {Boolean} Sets whether the width should be synced
   */
  syncWidth: false,

  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, [ options ]);
  },

  updateSize : function() {
    if (this.syncHeight) {
      var mapDivHeight = this.map.div.style.height;
      if (Legato.Lang.ObjectUtils.exists(mapDivHeight)) {
        this.div.style.height = mapDivHeight;
      }
    }
    if (this.syncWidth) {
      var mapDivWidth = this.map.div.style.width;
      if (Legato.Lang.ObjectUtils.exists(mapDivWidth)) {
        this.div.style.width = mapDivWidth;
      }
    }
  },

  setMap : function(map) {
    OpenLayers.Control.prototype.setMap.apply(this, arguments);
    this.map.events.on( {
      'moveend' :this.updateSize,
      scope :this
    });
  },

  destroy : function() {
    this.map.events.un( {
      'moveend' :this.updateSize,
      scope :this
    });
    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },

  CLASS_NAME :"Legato.Control.SyncMapDivSize"

});

Legato.Control.SyncMapDivSize.Bean = OpenLayers.Control.Bean.Extend(

'Legato.Control.SyncMapDivSize',

Legato.Control.QName('SyncMapDivSize'), {
  _constructor :Legato.Control.SyncMapDivSize,

  options : {
    syncWidth :Legato.Lang.Boolean,
    syncHeight :Legato.Lang.Boolean
  }
});
