/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @requires OpenLayers/BaseTypes.js
 * @requires OpenLayers/Lang/en.js
 * @requires OpenLayers/Console.js
 */

/*
 * TODO: In 3.0, we will stop supporting build profiles that include
 * OpenLayers.js. This means we will not need the singleFile and scriptFile
 * variables, because we don't have to handle the singleFile case any more.
 */

(function() {
    /**
     * Before creating the OpenLayers namespace, check to see if
     * OpenLayers.singleFile is true.  This occurs if the
     * OpenLayers/SingleFile.js script is included before this one - as is the
     * case with old single file build profiles that included both
     * OpenLayers.js and OpenLayers/SingleFile.js.
     */
    var singleFile = (typeof OpenLayers == "object" && OpenLayers.singleFile);

    /**
     * Relative path of this script.
     */
    var scriptName = (!singleFile) ? "lib/OpenLayers.js" : "OpenLayers.js";

    /*
     * If window.OpenLayers isn't set when this script (OpenLayers.js) is
     * evaluated (and if singleFile is false) then this script will load
     * *all* OpenLayers scripts. If window.OpenLayers is set to an array
     * then this script will attempt to load scripts for each string of
     * the array, using the string as the src of the script.
     *
     * Example:
     * (code)
     *     <script type="text/javascript">
     *         window.OpenLayers = [
     *             "OpenLayers/Util.js",
     *             "OpenLayers/BaseTypes.js"
     *         ];
     *     </script>
     *     <script type="text/javascript" src="../lib/OpenLayers.js"></script>
     * (end)
     * In this example OpenLayers.js will load Util.js and BaseTypes.js only.
     */
    var jsFiles = window.OpenLayers;

    /**
     * Namespace: OpenLayers
     * The OpenLayers object provides a namespace for all things OpenLayers
     */
    window.OpenLayers = {
        /**
         * Method: _getScriptLocation
         * Return the path to this script. This is also implemented in
         * OpenLayers/SingleFile.js
         *
         * Returns:
         * {String} Path to this script
         */
        _getScriptLocation: (function() {
            var r = new RegExp("(^|(.*?\\/))(" + scriptName + ")(\\?|$)"),
                s = document.getElementsByTagName('script'),
                src, m, l = "";
            for(var i=0, len=s.length; i<len; i++) {
                src = s[i].getAttribute('src');
                if(src) {
                    var m = src.match(r);
                    if(m) {
                        l = m[1];
                        break;
                    }
                }
            }
            return (function() { return l; });
        })()
    };

    /**
     * OpenLayers.singleFile is a flag indicating this file is being included
     * in a Single File Library build of the OpenLayers Library.
     *
     * When we are *not* part of a SFL build we dynamically include the
     * OpenLayers library code.
     *
     * When we *are* part of a SFL build we do not dynamically include the
     * OpenLayers library code as it will be appended at the end of this file.
     */
    if(!singleFile) {
        if (!jsFiles) {
            jsFiles = [
                       "OpenLayers/Util.js",
                       "OpenLayers/BaseTypes.js",
                       "OpenLayers/BaseTypes/Class.js",
                       "OpenLayers/BaseTypes/Bounds.js",
                       "OpenLayers/BaseTypes/Element.js",
                       "OpenLayers/BaseTypes/LonLat.js",
                       "OpenLayers/BaseTypes/Pixel.js",
                       "OpenLayers/BaseTypes/Size.js",
                       "OpenLayers/Console.js",
                       "OpenLayers/Tween.js",
                       "Rico/Corner.js",
                       "Rico/Color.js",
                       "OpenLayers/Ajax.js",
                       "OpenLayers/Events.js",
                       "OpenLayers/Request.js",
                       "OpenLayers/Request/XMLHttpRequest.js",
                       "OpenLayers/Projection.js",
                       "OpenLayers/Map.js",
                       "OpenLayers/Layer.js",
                       "OpenLayers/Icon.js",
                       "OpenLayers/Marker.js",
                       "OpenLayers/Marker/Box.js",
                       "OpenLayers/Popup.js",
                       "OpenLayers/Tile.js",
                       "OpenLayers/Tile/Image.js",
                       "OpenLayers/Tile/WFS.js",
                       "OpenLayers/Layer/Image.js",
                       "OpenLayers/Layer/SphericalMercator.js",
                       "OpenLayers/Layer/EventPane.js",
                       "OpenLayers/Layer/FixedZoomLevels.js",
                       "OpenLayers/Layer/Google.js",
                       "OpenLayers/Layer/VirtualEarth.js",
                       "OpenLayers/Layer/Yahoo.js",
                       "OpenLayers/Layer/HTTPRequest.js",
                       "OpenLayers/Layer/Grid.js",
                       "OpenLayers/Layer/MapGuide.js",
                       "OpenLayers/Layer/MapServer.js",
                       "OpenLayers/Layer/MapServer/Untiled.js",
                       "OpenLayers/Layer/KaMap.js",
                       "OpenLayers/Layer/KaMapCache.js",
                       "OpenLayers/Layer/MultiMap.js",
                       "OpenLayers/Layer/Markers.js",
                       "OpenLayers/Layer/Text.js",
                       "OpenLayers/Layer/WorldWind.js",
                       "OpenLayers/Layer/ArcGIS93Rest.js",
                       "OpenLayers/Layer/WMS.js",
                       "OpenLayers/Layer/WMS/Untiled.js",
                       "OpenLayers/Layer/ArcIMS.js",
                       "OpenLayers/Layer/GeoRSS.js",
                       "OpenLayers/Layer/Boxes.js",
                       "OpenLayers/Layer/XYZ.js",
                       "OpenLayers/Layer/TMS.js",
                       "OpenLayers/Layer/TileCache.js",
                       "OpenLayers/Popup/Anchored.js",
                       "OpenLayers/Popup/AnchoredBubble.js",
                       "OpenLayers/Popup/Framed.js",
                       "OpenLayers/Popup/FramedCloud.js",
                       "OpenLayers/Feature.js",
                       "OpenLayers/Feature/Vector.js",
                       "OpenLayers/Feature/WFS.js",
                       "OpenLayers/Handler.js",
                       "OpenLayers/Handler/Click.js",
                       "OpenLayers/Handler/Hover.js",
                       "OpenLayers/Handler/Point.js",
                       "OpenLayers/Handler/Path.js",
                       "OpenLayers/Handler/Polygon.js",
                       "OpenLayers/Handler/Feature.js",
                       "OpenLayers/Handler/Drag.js",
                       "OpenLayers/Handler/RegularPolygon.js",
                       "OpenLayers/Handler/Box.js",
                       "OpenLayers/Handler/MouseWheel.js",
                       "OpenLayers/Handler/Keyboard.js",
                       "OpenLayers/Control.js",
                       "OpenLayers/Control/Attribution.js",
                       "OpenLayers/Control/Button.js",
                       "OpenLayers/Control/ZoomBox.js",
                       "OpenLayers/Control/ZoomToMaxExtent.js",
                       "OpenLayers/Control/DragPan.js",
                       "OpenLayers/Control/Navigation.js",
                       "OpenLayers/Control/MouseDefaults.js",
                       "OpenLayers/Control/MousePosition.js",
                       "OpenLayers/Control/OverviewMap.js",
                       "OpenLayers/Control/KeyboardDefaults.js",
                       "OpenLayers/Control/PanZoom.js",
                       "OpenLayers/Control/PanZoomBar.js",
                       "OpenLayers/Control/ArgParser.js",
                       "OpenLayers/Control/Permalink.js",
                       "OpenLayers/Control/Scale.js",
                       "OpenLayers/Control/ScaleLine.js",
                       "OpenLayers/Control/Snapping.js",
                       "OpenLayers/Control/Split.js",
                       "OpenLayers/Control/LayerSwitcher.js",
                       "OpenLayers/Control/LoadingPanel.js",
                       "OpenLayers/Control/DrawFeature.js",
                       "OpenLayers/Control/DragFeature.js",
                       "OpenLayers/Control/ModifyFeature.js",
                       "OpenLayers/Control/Panel.js",
                       "OpenLayers/Control/SelectFeature.js",
                       "OpenLayers/Control/NavigationHistory.js",
                       "OpenLayers/Control/Measure.js",
                       "OpenLayers/Control/WMSGetFeatureInfo.js",
                       "OpenLayers/Geometry.js",
                       "OpenLayers/Geometry/Rectangle.js",
                       "OpenLayers/Geometry/Collection.js",
                       "OpenLayers/Geometry/Point.js",
                       "OpenLayers/Geometry/MultiPoint.js",
                       "OpenLayers/Geometry/Curve.js",
                       "OpenLayers/Geometry/LineString.js",
                       "OpenLayers/Geometry/LinearRing.js",
                       "OpenLayers/Geometry/Polygon.js",
                       "OpenLayers/Geometry/MultiLineString.js",
                       "OpenLayers/Geometry/MultiPolygon.js",
                       "OpenLayers/Geometry/Surface.js",
                       "OpenLayers/Renderer.js",
                       "OpenLayers/Renderer/Elements.js",
                       "OpenLayers/Renderer/SVG.js",
                       "OpenLayers/Renderer/Canvas.js",
                       "OpenLayers/Renderer/VML.js",
                       "OpenLayers/Layer/Vector.js",
                       "OpenLayers/Layer/Vector/RootContainer.js",
                       "OpenLayers/Strategy.js",
                       "OpenLayers/Strategy/Fixed.js",
                       "OpenLayers/Strategy/Cluster.js",
                       "OpenLayers/Strategy/Paging.js",
                       "OpenLayers/Strategy/BBOX.js",
                       "OpenLayers/Strategy/Save.js",
                       "OpenLayers/Protocol.js",
                       "OpenLayers/Protocol/HTTP.js",
                       "OpenLayers/Protocol/SQL.js",
                       "OpenLayers/Protocol/SQL/Gears.js",
                       "OpenLayers/Protocol/WFS.js",
                       "OpenLayers/Protocol/WFS/v1.js",
                       "OpenLayers/Protocol/WFS/v1_0_0.js",
                       "OpenLayers/Protocol/WFS/v1_1_0.js",
                       "OpenLayers/Layer/PointTrack.js",
                       "OpenLayers/Layer/GML.js",
                       "OpenLayers/Style.js",
                       "OpenLayers/StyleMap.js",
                       "OpenLayers/Rule.js",
                       "OpenLayers/Filter.js",
                       "OpenLayers/Filter/FeatureId.js",
                       "OpenLayers/Filter/Logical.js",
                       "OpenLayers/Filter/Comparison.js",
                       "OpenLayers/Filter/Spatial.js",
                       "OpenLayers/Format.js",
                       "OpenLayers/Format/XML.js",
                       "OpenLayers/Format/ArcXML.js",
                       "OpenLayers/Format/ArcXML/Features.js",
                       "OpenLayers/Format/GML.js",
                       "OpenLayers/Format/GML/Base.js",
                       "OpenLayers/Format/GML/v2.js",
                       "OpenLayers/Format/GML/v3.js",
                       "OpenLayers/Format/KML.js",
                       "OpenLayers/Format/GeoRSS.js",
                       "OpenLayers/Format/WFS.js",
                       "OpenLayers/Format/WFSCapabilities.js",
                       "OpenLayers/Format/WFSCapabilities/v1.js",
                       "OpenLayers/Format/WFSCapabilities/v1_0_0.js",
                       "OpenLayers/Format/WFSCapabilities/v1_1_0.js",
                       "OpenLayers/Format/WFSDescribeFeatureType.js",
                       "OpenLayers/Format/WMSDescribeLayer.js",
                       "OpenLayers/Format/WMSDescribeLayer/v1_1.js",
                       "OpenLayers/Format/WKT.js",
                       "OpenLayers/Format/OSM.js",
                       "OpenLayers/Format/GPX.js",
                       "OpenLayers/Format/Filter.js",
                       "OpenLayers/Format/Filter/v1.js",
                       "OpenLayers/Format/Filter/v1_0_0.js",
                       "OpenLayers/Format/Filter/v1_1_0.js",
                       "OpenLayers/Format/SLD.js",
                       "OpenLayers/Format/SLD/v1.js",
                       "OpenLayers/Format/SLD/v1_0_0.js",
                       "OpenLayers/Format/SLD/v1.js",
                       "OpenLayers/Format/WFST.js",
                       "OpenLayers/Format/WFST/v1.js",
                       "OpenLayers/Format/WFST/v1_0_0.js",
                       "OpenLayers/Format/WFST/v1_1_0.js",
                       "OpenLayers/Format/Text.js",
                       "OpenLayers/Format/JSON.js",
                       "OpenLayers/Format/GeoJSON.js",
                       "OpenLayers/Format/WMC.js",
                       "OpenLayers/Format/WMC/v1.js",
                       "OpenLayers/Format/WMC/v1_0_0.js",
                       "OpenLayers/Format/WMC/v1_1_0.js",
                       "OpenLayers/Format/WMSCapabilities.js",
                       "OpenLayers/Format/WMSCapabilities/v1_1.js",
                       "OpenLayers/Format/WMSCapabilities/v1_1_0.js",
                       "OpenLayers/Format/WMSCapabilities/v1_1_1.js",
                       "OpenLayers/Format/WMSGetFeatureInfo.js",
                       "OpenLayers/Layer/WFS.js",
                       "OpenLayers/Control/GetFeature.js",
                       "OpenLayers/Control/MouseToolbar.js",
                       "OpenLayers/Control/NavToolbar.js",
                       "OpenLayers/Control/PanPanel.js",
                       "OpenLayers/Control/Pan.js",
                       "OpenLayers/Control/ZoomIn.js",
                       "OpenLayers/Control/ZoomOut.js",
                       "OpenLayers/Control/ZoomPanel.js",
                       "OpenLayers/Control/EditingToolbar.js",
                       "OpenLayers/Lang.js",
                       "OpenLayers/Lang/en.js"
            ]; // etc.
        }

        // use "parser-inserted scripts" for guaranteed execution order
        // http://hsivonen.iki.fi/script-execution/
        var scriptTags = new Array(jsFiles.length);
        var host = OpenLayers._getScriptLocation() + "lib/";
        for (var i=0, len=jsFiles.length; i<len; i++) {
            scriptTags[i] = "<script src='" + host + jsFiles[i] +
                                   "'></script>";
        }
        if (scriptTags.length > 0) {
            document.write(scriptTags.join(""));
        }
    }
})();

/**
 * Constant: VERSION_NUMBER
 */
OpenLayers.VERSION_NUMBER="$Revision$";
