/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Revision: 69543 $
 * @requires Legato.js
 * @requires OpenLayers/Control.js
 */

/**
 * Class: Legato.Control
 * Abstract base class for all Legato control classes
 *
 * Inherits from:
 *  - <OpenLayers.Control>
 */
Legato.Control = OpenLayers.Class(OpenLayers.Control, {
	CLASS_NAME : 'Legato.Control'
});

/**
 * Space: lc
 * Namespace for Legato controls.
 */
/*
 * URI: Namespace URI
 * {http://www.disy.net/legato/control}
 */
Legato.Control.NAMESPACE_URI = 'http://www.disy.net/legato/control';

/*
 * Prefix: Default prefix
 * {lc}
 */
Legato.Control.PREFIX = 'lc';

Legato.Control.QName = function(localPart) {
	return new Legato.XML.QName(Legato.Control.NAMESPACE_URI, localPart,
			Legato.Control.PREFIX);
};
/**
 * Component: lc:Control
 * Configuration component for Legato Controls.
 * See also:
 * - <lc> namespace
 * - <Legato.Control>
 */
Legato.Control.Bean = OpenLayers.Control.Bean.Extend('Legato.Control',
//
Legato.Control.QName('Control'),
//
{
	_constructor : Legato.Control
});
