/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 70574 $
 */

/*
 * Class: Legato.Lang.Exception
 */
Legato.Lang.Exception = Legato.Lang.Class( {
  /*
   * Property: message
   *
   * Exception message.
   */
  message :null,
  /*
   * Property: cause
   *
   * Exception cause.
   */
  cause :null,
  /*
   * Constructor: initialize
   *
   * Constructs a new exception.
   *
   * Parameters:
   *
   * message - {String} exception message (optional).
   *
   * cause - exception cause (optional).
   */
  initialize : function(message, cause) {
    if (Legato.Lang.ObjectUtils.exists(message)) {
      Legato.Util.Ensure.ensureString(message);
      this.message = message;
    } else {
      this.message = null;
    }
    if (Legato.Lang.ObjectUtils.exists(cause)) {
      this.cause = cause;
    } else {
      this.cause = null;
    }
  },

  toString: function(){
    return this.CLASS_NAME + ': ' + this.message;
  },

  CLASS_NAME: 'Exception'
});
