/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Result.Viewport = OpenLayers.Class(WPS.Result.BoundingBox, {

  initialize : function(id, map, bounds, options) {
    WPS.Result.BoundingBox.prototype.initialize.apply(this, [ id, map, bounds, options ]);
  },

  destroy : function() {
    WPS.Result.BoundingBox.prototype.destroy.apply(this, arguments);
  },

  CLASS_NAME :'WPS.Result.Polygon'
});

WPS.Result.Viewport.ComplexFactory = OpenLayers.Class(WPS.Result.ComplexFactory, {
  schema : 'http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#Viewport',

  name : new Legato.XML.QName('http://www.disy.net/pd', 'Viewport', 'pd'),

  map : null,

  factory : null,

  initialize : function(map) {
    Legato.Util.Ensure.ensureExists(map, 'map should be defined');
    this.map = map;
  },

  createResult : function(id, outputData, options) {
    var envelope = outputData.data.complexData.content[0].value.envelope.value;

    var bounds = new OpenLayers.Bounds(
      envelope.ulx,
      envelope.uly,
      envelope.lrx,
      envelope.lry);

    //
    return new WPS.Result.Viewport(id, this.map, bounds, options);
  },
  CLASS_NAME : 'WPS.Result.Viewport.ComplexFactory'
});