/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.ProcessSelector = OpenLayers.Class( {
  container: null,
  menuContainer: null,
  menuElement: null,
  processDescriptions: null,
  selectedCallback: null,
  cancelCallback: null,
  abstractElement: null,
  buttonsElement: null,
  okButton: null,
  cancelButton: null,
  selectedProcessId: null,
  txtSelect: 'OK',
  txtCancel: 'Cancel',
  initialize : function(processDescriptions, selectedCallback, cancelCallback, options) {
    Legato.Util.Ensure.ensureArray(processDescriptions, "processDescriptions should be defined");
    Legato.Util.Ensure.ensureFunction(selectedCallback, "selected callback should be a function");
    Legato.Util.Ensure.ensureFunction(cancelCallback, "cancel callback should be a function");
    this.processDescriptions = processDescriptions;
    this.selectedCallback = selectedCallback;
    this.cancelCallback = cancelCallback;
    OpenLayers.Util.extend(this, options);
    if (this.container === null) {
      this.container = document.createElement('div');
      this.container.className = 'wpsContainer';
    }

    this.titleElement = document.createElement('div');
    this.titleElement.className = 'wpsContainerTitle';
    this.titleElement.innerHTML = WPS.I18n.getMessage('WPS.ProcessSelector.Title');
    this.container.appendChild(this.titleElement);

    this.abstractElement =  document.createElement('div');
    this.abstractElement.className = 'wpsContainerAbstract';
    this.abstractElement.innerHTML = WPS.I18n.getMessage('WPS.ProcessSelector.Description');
    this.container.appendChild(this.abstractElement);

    this.generateInputContainer();

    this.buttonsElement = document.createElement('div');
    this.buttonsElement.className = 'wpsButtons';
    this.container.appendChild(this.buttonsElement);

    this.okButton = document.createElement('input');
    this.okButton.id = 'wpsProcessSelectionOKButton';
    this.okButton.type = 'button';
    this.okButton.value = this.txtSelect;
    this.okButton.disabled = true;
    this.okButton.onclick = OpenLayers.Function.bindAsEventListener(
        this.okButtonClicked, this);
    this.buttonsElement.appendChild(this.okButton);

    this.cancelButton = document.createElement('input');
    this.cancelButton.id = 'wpsProcessSelectionCancelButton';
    this.cancelButton.type = 'button';
    this.cancelButton.value = this.txtCancel;
    this.cancelButton.disabled = false;
    this.cancelButton.onclick = OpenLayers.Function.bindAsEventListener(
        this.cancelButtonClicked, this);
    this.buttonsElement.appendChild(this.cancelButton);
  },

  okButtonClicked: function() {
    this.selectedCallback(/*this, */this.selectedProcessId);
  },

  cancelButtonClicked: function() {
    this.selectProcess(null);
    var options = this.menuElement.childNodes;
    for (var i=0; i < options.length; i++) {
      var value = options[i].value;
      if ('' === value) {
        options[i].selected = true;
      } else {
        options[i].selected = false;
      }
    }
    this.cancelCallback(this);
  },

  generateInputContainer: function() {
    var inputContainer =  document.createElement('div');
    inputContainer.className = 'wpsProcessSelectionInputsContainer';

    this.menuContainer = document.createElement('div');
    this.menuContainer.className = 'wpsProcessSelectionDropDownContainer';

    this.menuElement = document.createElement('select');
    this.menuElement.id = 'wpsProcessesSelectionDropDown';
    this.menuElement.className = 'wpsProcessesSelectionDropDown';
    this.menuElement.size = this.processDescriptions.length > 10 ? 10 : this.processDescriptions.length;

    this.menuContainer.appendChild(this.menuElement);
    inputContainer.appendChild(this.menuContainer);

    this.descriptionContainer = document.createElement('div');
    this.descriptionContainer.className = 'wpsProcessSelectionDescriptionContainer';

    this.descriptionInfoText = document.createElement('div');
    this.descriptionInfoText.className = 'wpsProcessSelectionInfoText';
    this.descriptionInfoText.innerHTML = WPS.I18n.getMessage('WPS.ProcessSelector.ProcessSelectionInfoTextDescription');

    this.abstractElement = document.createElement('div');
    this.abstractElement.className = 'wpsProcessSelectionAbstract';
    this.abstractElement.innerHTML = '';
    Legato.XML.ElementUtils.hide(this.descriptionContainer);

    this.descriptionContainer.appendChild(this.descriptionInfoText);
    this.descriptionContainer.appendChild(this.abstractElement);
    inputContainer.appendChild(this.descriptionContainer);

    this.container.appendChild(inputContainer);

    for (var index = 0; index < this.processDescriptions.length; index++)
    {
      var process = this.processDescriptions[index];
      var optionElement = this.createOption(process.title.value, process.identifier.value, false);
      this.menuElement.appendChild(optionElement);
    }
    this.menuElement.onchange = OpenLayers.Function.bindAsEventListener(
        this.processChanged, this);
  },

  createOption : function(name, value, selected) {
    var option = document.createElement('option');
    option.value = value;
    option.selected = selected;
    option.innerHTML = name;
    option.title = name;
    return option;
  },

  processChanged: function(event) {
    var selectedProcessId = (event.target || event.srcElement).value;
    this.selectProcess(selectedProcessId);
  },

  selectProcess: function(processId) {
    this.selectedProcessId = null;
    if (processId) {
      for (var index = 0; index < this.processDescriptions.length; index++)
      {
        var process = this.processDescriptions[index];
        if (processId === process.identifier.value) {
          this.selectedProcessId = processId;
          /*jslint sub:true*/
          this.abstractElement.innerHTML = process['abstract'].value;
          Legato.XML.ElementUtils.show(this.descriptionContainer);
          this.okButton.disabled = false;
          break;
        }
      }
    }
    if (! this.selectedProcessId)  {
      this.abstractElement.innerHTML = '';
      Legato.XML.ElementUtils.hide(this.descriptionContainer);
      this.okButton.disabled = true;
    }
  },

  destroy: function() {
    this.processDescriptions = null;
    this.selectedCallback = null;
    this.cancelCallback = null;
  },

  CLASS_NAME :'WPS.ProcessSelector'
});
