/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: valikov $
 * @version $Revision: 69543 $
 * @requires WPS.js
 */

/**
 * Structure: WPS.Predicate Abstract base class for all WPS process predicates
 * 
 */
WPS.Predicate = OpenLayers.Class( {
  initialize : function(options) {
    OpenLayers.Util.extend(this, options);
  },
  evaluate : function(processDescription) {
    return true;
  },
  CLASS_NAME :'WPS.Predicate'
});

WPS.Predicate.And = OpenLayers.Class( {
  predicates :null,
  initialize : function(predicates) {
    this.predicates = predicates;
  },
  evaluate : function(processDescription) {
    for ( var index = 0; index < this.predicates.length; index++) {
      var currentPredicate = this.predicates[index];
      if (!currentPredicate.evaluate(processDescription)) {
        return false;
      }
    }
    return true;
  },
  CLASS_NAME :'WPS.Predicate.And'
});

WPS.Predicate.Or = OpenLayers.Class( {
  predicates :null,
  initialize : function(predicates) {
    Legato.Util.Ensure.ensureArray(predicates);
    this.predicates = predicates;
  },
  evaluate : function(processDescription) {
    for ( var index = 0; index < this.predicates.length; index++) {
      var currentPredicate = this.predicates[index];
      if (currentPredicate.evaluate(processDescription)) {
        return true;
      }
    }
    return false;
  },
  CLASS_NAME :'WPS.Predicate.Or'
});

WPS.Predicate.Not = OpenLayers.Class( {
  predicate :null,
  initialize : function(predicate) {
    this.predicate = predicate;
  },
  evaluate : function(processDescription) {
    return !this.predicate.evaluate(processDescription);
  },
  CLASS_NAME :'WPS.Predicate.Not'
});
WPS.Predicate.True = OpenLayers.Class( {
  initialize : function(options) {
    OpenLayers.Util.extend(this, options);
  },
  evaluate : function(processDescription) {
    return true;
  },
  CLASS_NAME :'WPS.Predicate.True'
});
WPS.Predicate.TrueIfTagless = OpenLayers.Class( {
  initialize : function(options) {
    OpenLayers.Util.extend(this, options);
  },
  evaluate : function(processDescription) {
    var metadata = processDescription.metadata;
    if (metadata) {
      for (var key in metadata) {
        if(metadata.hasOwnProperty(key)) {
          var metadataObject = metadata[key];
          if (metadataObject.about === 'tag') {
            return false;
          }
        }
      }
    }
    return true;
  },
  CLASS_NAME :'WPS.Predicate.True'
});
WPS.Predicate.False = OpenLayers.Class( {
  initialize : function(options) {
    OpenLayers.Util.extend(this, options);
  },
  evaluate : function(processDescription) {
    return false;
  },
  CLASS_NAME :'WPS.Predicate.False'
});

/*
 * Property: NAMESPACE_URI Defines the Namespace URI for all WPS Predicate
 * Elements. Needed in XML based config files.
 */
WPS.Predicate.NAMESPACE_URI = 'http://www.disy.net/WPS/predicate';

/*
 * Property: PREFIX Global defined prefix for all WPS Predicate classes.
 */
WPS.Predicate.PREFIX = 'lwpsp';

/*
 * Property: QName Defines the qualified name. Needed for XML based config.
 */
WPS.Predicate.QName = function(localPart) {
  return new Legato.XML.QName(WPS.Predicate.NAMESPACE_URI, localPart,
      WPS.Predicate.PREFIX);
};

/**
 * Structure: lwpsp:somePredicate XML based config for a <WPS.Predicate>
 * subclasses.
 * 
 * See Also: - <Predicate>
 * - &lt;QName&gt;
 * - &lt;PREFIX&gt;
 * - &lt;Legato.Beans.BeanFactory&gt;
 * All WPS predicates could be configured using XML. If so, the config needs to define
 * the namespace prefix (&lt;PREFIX&gt;). The needed namespace URL should point to &lt;NAMESPACE_URI&gt;.
 * After that you're able to configure all WPS predicate subclasses via XML.
 * A valid example could be:
 * (start code)
 * &lt;lwpsp:somePredicate foo=&quot;bar&quot;/&gt;
 * (end)
 * For detailed informations have a look at the &lt;WPS.Predicate&gt; subclass documentation.
 * 
 */
WPS.Predicate.Bean = Legato.Beans.Object.Extend('WPS.Predicate',
//
    WPS.Predicate.QName('Predicate'),
    //
    {
      _constructor :WPS.Predicate
    });
