/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

LegatoJQuery.Control.MapResizer = OpenLayers.Class(OpenLayers.Control, {

  type : OpenLayers.Control.TYPE_TOOL,
  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, [ options ]);
  },
  draw : function() {
    var div = OpenLayers.Control.prototype.draw.apply(this, arguments);
    return div;
  },
  setMap : function(map) {
    OpenLayers.Control.prototype.setMap.apply(this, arguments);
    OpenLayers.Function.bind(jQuery(this.map.div).resizable({
      stop: OpenLayers.Function.bind(this.onMapResized, this)
    }), this);
  },
  onMapResized: function(event, ui){
    this.map.updateSize();
  },
  destroy : function() {
  },
  CLASS_NAME : "LegatoJQuery.Control.MapResizer"
});

/**
 * Component: ljqc:MapResizer
 *
 * The MapResizer control adds resizing capabilities for the OpenLayers map using jQuery.
 *
 * See also:
 * - <ljqc> namespace
 */
LegatoJQuery.Control.MapResizer.Bean = OpenLayers.Control.Bean.Extend(

'LegatoJQuery.Control.MapResizer',

LegatoJQuery.Control.QName('MapResizer'), {
  _constructor : LegatoJQuery.Control.MapResizer,
  options : {
  }
});