/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * (c)2006 Jesse Skinner/Dean Edwards/Matthias Miller/John Resig
 * Special thanks to Dan Webb's domready.js Prototype extension
 * and Simon Willison's addLoadEvent
 *
 * For more info, see:
 * http://www.thefutureoftheweb.com/blog/adddomloadevent
 * http://dean.edwards.name/weblog/2006/06/again/
 * http://www.vivabit.com/bollocks/2006/06/21/a-dom-ready-extension-for-prototype
 * http://simon.incutio.com/archive/2004/05/26/addLoadEvent
 *
 *
 * To use: call addDOMLoadEvent one or more times with functions, ie:
 *
 *    function something() {
 *       // do something
 *    }
 *    addDOMLoadEvent(something);
 *
 *    addDOMLoadEvent(function() {
 *        // do other stuff
 *    });
 *
 */

/**
 * Class: Legato.Util.DOM.addDOMLoadEvent
 * Gives you the abbility to specifiy a callback function which will been
 * executed when the DOM has loaded.
 */

Legato.Util.DOM = {
  unloadStack: [],
  oldUnLoad: null,
  done: false
};

Legato.Util.DOM.addDOMLoadEvent = (function() {
  // create event function stack
  var load_events = [], load_timer, script, done, exec, old_onload, init = function() {
    done = true;

    // kill the timer
    clearInterval(load_timer);

    // execute each function in the stack in the order they were added
    exec = load_events.shift();
    while(exec){
      exec();
      exec = load_events.shift();
    }

    if (script){
      script.onreadystatechange = '';
    }

    if(!Legato.Util.DOM.done){
      Legato.Util.DOM.done = true;
      Legato.Util.DOM.oldUnLoad = window.onunload;
      window.onunload = OpenLayers.Function.bind(Legato.Util.DOM.unload, Legato.Util.DOM);
    }
  };

  return function(func) {
    // if the init function was already ran, just run this function now and stop
    if (done){
      return func();
    }

    if (!load_events[0]) {
      // for Mozilla/Opera9
      if (document.addEventListener)
      {
        document.addEventListener("DOMContentLoaded", init, false);
      }

      // for Internet Explorer
      /*@cc_on
      @if (@_win32)
         document.write("<script id=__ie_onload defer src=//0><\/scr"+"ipt>");
         script = document.getElementById("__ie_onload");
         script.onreadystatechange = function() {
           if (this.readyState == "complete"){
             init();
           }
         };
      @end
      @*/

      // for Safari
      if (/WebKit/i.test(navigator.userAgent)) { // sniff
        load_timer = setInterval(function() {
          if (/loaded|complete/.test(document.readyState))
          {
            init(); // call the onload handler
          }
        }, 10);
      }

      // for other browsers set the window.onload, but also execute the old
      // window.onload
      old_onload = window.onload;
      window.onload = function() {
        init();
        if (old_onload){
          old_onload();
        }
      };
    }

    load_events.push(func);
  };
})();

Legato.Util.DOM.unload = function(event){
  // execute each function in the stack in the order they were added
  exec = this.unloadStack.shift();
  while(exec){
    exec();
    exec = this.unloadStack.shift();
  }
  if(this.oldUnLoad){
    this.oldUnLoad();
  }
};

Legato.Util.DOM.addDOMUnLoadEvent = function(callback){
  this.unloadStack.push(callback);
};

if (document.addEventListener)
{
  document.addEventListener("DOMWindowClose", Legato.Util.DOM.unload, false);
}