/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

OpenLayers.Layer.Image.Bean = OpenLayers.Layer.Bean.Extend(
  'OpenLayers.Layer.Image',
  Legato.OpenLayers.Layer.QName('Image'),
  {
    //_constructor :OpenLayers.Layer.Image,
    factoryFunction:function(name, url, options)
    {
      // Ensure that no port 80 is added, otherwise when using https this leads to an URL that
      // mixes https and port 80...
      var urlObject = OpenLayers.Util.createUrlObject(url, {ignorePort80: true});
      urlObject.args.w = options.size.w;
      urlObject.args.h = options.size.h;

      url = Legato.Util.getUrlString(urlObject);

      OpenLayers.Console.debug(url);

      options.isBaseLayer = true;
      options.visibility = true;

      var layer = new OpenLayers.Layer.Image(
        name,
        url,
        options.extent,
        options.size,
        options
      );
      return layer;
    },
    constructorArguments : {
      name :Legato.Lang.String,
      url :Legato.Lang.String
    },
    constructorOrder : [ 'name', 'url' ],
    options : {
      size: OpenLayers.Size.Bean,
      extent :OpenLayers.Bounds.Bean
    }
  }
);

OpenLayers.Layer.Image.LayerFactory = Legato.Lang.Class(
  Legato.Format.ExtendedWMC.LayerFactory,
  {
    layerType : OpenLayers.Layer.Image.Bean
  }
);

Legato.Format.ExtendedWMC.registerDefaultLayerFactory(
  'OpenLayer:Image',
  new OpenLayers.Layer.Image.LayerFactory()
);