/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: valikov $
 * @version $Rev: 91043 $
 * @base Legato.Control
 * @requires Legato/Control.js
 */

/**
 * Class: Legato.Control.SynchronousSnappingResolver
 * 
 * Inherits from: - <Legato.Control>
 */
Legato.Control.SynchronousSnappingResolver = OpenLayers.Class(Legato.Control, {

  logger : null,

  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, [ options ]);
    this.logger = Legato.Util.Logger.getLogger();
  },

  getSnapPoint : function(layerid, resolution, worldPoint, callback) {
    var that = this;
    var onSuccess = function(result) {
      return that.onSuccess(result, callback);
    };
    var onFailure = function(message, exception) {
      return that.onFailure(message, exception);
    };

    this.locker.lockElement();
    var result = that.snappingResolver.getSnapPoint(layerid, resolution, worldPoint, {
      callback : onSuccess,
      exceptionHandler : onFailure
    });
  },

  getSnapPoints : function(layerid, resolution, lastPoint, worldPoint, callback) {
    var that = this;
    var onSuccess = function(result) {
      return that.onSuccess(result, callback);
    };
    var onFailure = function(message, exception) {
      return that.onFailure(message, exception);
    };
    this.locker.lockElement();
    var result = this.snappingResolver.getSnapPoints(layerid, resolution, lastPoint, worldPoint, {
      callback : onSuccess,
      exceptionHandler : onFailure
    });
  },

  onSuccess : function(result, callback) {
    this.locker.unlockElement();
    return callback(result);
  },

  onFailure : function(message, exception) {
    this.locker.unlockElement();
  },

  CLASS_NAME : 'Legato.Control.SynchronousSnappingResolver'
});

/**
 * Structure: lc:SynchronousSnappingResolver XML based config for a
 * <Legato.Control.SynchronousSnappingResolver>.
 * 
 * See Also: - <Legato.Control> - <Legato.Beans.BeanFactory> - <QName>
 *     
 * A valid config example for a SynchronousSnappingResolver would be:
 * (start code)
 * <lc:SynchronousSnappingResolver>
 *   <snappingResolver>
 *    <lb:Reference target="DwrSnappingResolver"/>
 *   </snappingResolver>
 *   <locker>
 *     <lb:Reference target="CallbackLocker"/>
 *   </locker>
 * </lc:SynchronousSnappingResolver>
 * (end)
 */
Legato.Control.SynchronousSnappingResolver.Bean = Legato.Control.Bean.Extend(

'Legato.Control.SynchronousSnappingResolver',

/*
 * Property: QName The qualified name for this control. Needed by XML config to
 * instantiate it.
 */
Legato.Control.QName('SynchronousSnappingResolver'), {
  _constructor : Legato.Control.SynchronousSnappingResolver,
  options : {
    snappingResolver : Legato.Lang.Function,
    locker : Legato.Beans.Object
  }
});
