/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.StylePropertiesEditor = OpenLayers.Class(Legato.Control, {

  style : null,

  factory : null,
  
  layer : null,

  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, [ options ]);
    this.createDiv();
  },

  setStyle : function(style) {
    this.style = style;
    this.refresh();
  },
  
  setLayer : function(layer){
    this.layer = layer;
  },

  refresh : function() {
    this.div.innerHTML = '';
    var styleType = this.style['x-type'];
    var styleProperties = Legato.StyleProperties.STYLE_PROPERTIES[styleType];
    for ( var i = 0; i < styleProperties.length; i++) {
      var stylePropertyName = styleProperties[i];
      var stylePropertyValue = this.style[stylePropertyName];
      var stylePropertyElement = this.factory.createElement(stylePropertyName,
          stylePropertyValue, this.style, this.layer);
      stylePropertyElement.appendTo(this.div);
    }
  },

  createDiv : function() {
    this.div = OpenLayers.Util.createDiv(this.id);
    this.div.className = this.displayClass;
    this.div.style.position = 'relative';
  },

  deactivate : function() {
    Legato.Control.prototype.deactivate.apply(this, [ arguments ]);
    this.div.style.display = 'none';
  },

  activate : function() {
    Legato.Control.prototype.activate.apply(this, [ arguments ]);
    this.div.style.display = '';
  },

  draw : function(px) {
    if (this.div === null) {
      this.createDiv();
    }
    if (Legato.Lang.ObjectUtils.exists(px)) {
      this.position = px.clone();
    }
    this.moveTo(this.position);
    return this.div;
  },

  CLASS_NAME : 'Legato.Control.StylePropertiesEditor'
});
Legato.Control.StylePropertiesEditor.Bean = Legato.Control.Bean.Extend(
//
'Legato.Control.StylePropertiesEditor',
//
Legato.Control.QName('StylePropertiesEditor'),
//
{
  _constructor : Legato.Control.StylePropertiesEditor,
  options : {
    factory : Legato.StyleProperties.Factory
  }
});