/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.SnappableLayerSelector = OpenLayers.Class(Legato.Control,
{
  map :null,

  targetSnappingController: null,

  div: null,

  selectElement: null,
  
  selectLabel: null,

  txtSelect: 'Please choose an option',

  txtNoSnapping: 'No snapping',

  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, arguments);
  },

  /*
   * Function: setMap Set the map property for the control.
   *
   * Parameters: map - {<OpenLayers.Map>}
   */
  setMap : function(map) {
    OpenLayers.Control.prototype.setMap.apply(this, arguments);
    this.map.events.on( {
      'addlayer' : this.layerAdded,
      'removelayer' : this.layerRemoved,
      scope : this
    });
  },

  /*
   * Function: destroy APIMethod: called if destroyed
   */
  destroy : function() {
    this.map.events.un( {
      'addlayer' : this.layerAdded,
      'removelayer' : this.layerRemoved,
      scope : this
    });
  },

  draw : function() {
    if (this.selectLabel !== null) {
      this.div.removeChild(this.selectLabel);
    }
    
    this.selectLabel = document.createElement('span');
    this.selectLabel.innerHTML = this.txtSelect + ' ';
    this.div.appendChild(this.selectLabel);
    
    if (this.selectElement !== null){
      this.div.removeChild(this.selectElement);
    }
    
    this.selectElement = document.createElement('select');
    this.selectElement.className = 'snappableLayerSelectionDropDown';

    this.selectElement.onchange = OpenLayers.Function.bindAsEventListener(
        this.selectionChanged, this);
    this.selectElement.appendChild(this.createOption(this.txtNoSnapping, null, false));

    this.div.appendChild(this.selectElement);

    var layerId = this.targetSnappingController.getLayerId();

    var snappableLayers = Legato.OpenLayers.Map.Util.getSnappableLayers(this.map.layers);

    for (var index = 0; index < snappableLayers.length; index++)
    {
      var layer = snappableLayers[index];
      this.selectElement.appendChild(this.createOption(layer.title, layer.layerId, (layerId === layer.layerId)));
    }

    return this.div;
  },

  selectionChanged: function(event) {
    var layerId = (event.target || event.srcElement).value;
    this.targetSnappingController.setLayerId(layerId);
  },

  createOption : function(name, value, selected) {
    var option = document.createElement('option');
    option.value = value;
    option.selected = selected;
    option.innerHTML = name;
    return option;
  },

  layerAdded: function(event){
    this.draw();
  },

  layerRemoved: function(event){
    this.draw();
  },

  CLASS_NAME : 'Legato.Control.SnappableLayerSelector'
});


Legato.Control.SnappableLayerSelector.Bean = OpenLayers.Control.Bean.Extend(

  'Legato.Control.SnappableLayerSelector',

 /*
   * Property: QName The qualified name for this control. Needed by XML config
   * to instantiate it.
   */
  Legato.Control.QName('SnappableLayerSelector'),
  {
    _constructor: Legato.Control.SnappableLayerSelector,
    options: {
      map: OpenLayers.Map,
      div: Legato.Lang.Element,
      targetSnappingController: Legato.Control.SnappingController.Bean,
      txtSelect: Legato.Lang.String,
      txtNoSnapping: Legato.Lang.String
    }
  }
);
