/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Rev: 72369 $
 * @base Legato.Control.Legend.Plugin
 * @requires Legato/Control.js
 * @requires Legato/Legend.js
 * @requires Legato/Legend/Plugin.js
 */

/**
 * Class: Legato.Control.Legend.Plugin.LayerVisibility
 */
Legato.Control.Legend.Plugin.LayerVisibility = OpenLayers.Class(
		Legato.Control.Legend.Plugin, {

			/**
			 * Property: afterSetup
			 */
			input : null,

			/**
			 * Function: create
			 */
			create : function() {
				Legato.Control.Legend.Plugin.prototype.create.apply(this,
						arguments);
				this.input = document.createElement('input');
				this.input.value = this.layer.name;
				if (this.layer.isBaseLayer) {
					this.input.type = 'radio';
					// TODO
					this.input.name = 'baseLayer';
					this.input.className = this.displayClass + 'Input' + ' '
							+ this.displayClass + 'InputBaseLayer';

				} else {
					this.input.type = 'checkbox';
					this.input.name = 'overlay';
					this.input.className = this.displayClass + 'Input' + ' '
							+ this.displayClass + 'InputOverlay';
				}
				this.div.appendChild(this.input);
				this.input.value = this.layer.name;
				this.input.defaultChecked = this.layer.visibility;
			},

			/**
			 * Function: update
			 */
			update : function() {
				this.input.value = this.layer.name;
				this.input.checked = this.layer.visibility;
			},

			/**
			 * Function: afterSetup
			 */
			afterSetup : function() {
				this.input.onclick = OpenLayers.Function.bindAsEventListener(
						this.onclick, this);
				this.layer.events.on({
					'visibilitychanged' : this.update,
					scope : this
				});
				// Currently when a base layer is changed, there's no visibilitychanged event
				// for the new base layer which became visible. Therefor we have to watch for
				// changebaselayer events on the map.
				if (this.layer.isBaseLayer) {
					this.map.events.on({
						'changebaselayer' : this.update,
						scope : this
					});
				}
			},

			/**
			 * Function: beforeDestroyed
			 */
			beforeDestroyed : function() {
				this.input.onclick = null;
				this.layer.events.un({
					'visibilitychanged' : this.update,
					scope : this
				});
				this.map.events.un({
					'changebaselayer' : this.update,
					scope : this
				});
			},
			/**
			 * Function: onclick
			 */
			onclick : function(event) {
				if (this.layer.isBaseLayer && this.input.checked) {
					this.layer.map.setBaseLayer(this.layer);
				} else {
					this.layer.setVisibility(this.input.checked);
				}
				if (Legato.Lang.ObjectUtils.exists(event)) {
					OpenLayers.Event.stop(event, true);
				}
			},

			CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerVisibility'
		});

/**
 * Class: Legato.Control.Legend.Plugin.LayerVisibility.Factory
 * Factory class wich is able to create a <Legato.Control.Legend.Plugin.LayerVisibility>
 * instance.
 */
Legato.Control.Legend.Plugin.LayerVisibility.Factory = OpenLayers.Class(
		Legato.Control.Legend.Plugin.Factory, {

			/**
			 * Function: create
			 * Factory method for creating a <Legato.Control.Legend.Plugin.LayerVisibility> instance.
			 */
			create : function(layer) {
				return new Legato.Control.Legend.Plugin.LayerVisibility(layer,
						this.pluginOptions);
			},

			CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerVisibility.Factory'
		});

/**
 * Component: llp:LayerVisibility
 * 
 * Inherits from:
 * - <llp:Plugin>
 * 
 * See Also:
 * - <llp> namespace
 * - {<Legato.Control.Legend.Plugin.LayerVisibility>}
 */
Legato.Control.Legend.Plugin.LayerVisibility.Bean = Legato.Control.Legend.Plugin.Bean
		.Extend('Legato.Control.Legend.Plugin.LayerVisibility.Factory',

		/**
		 * Property: QName
		 * The qualified name for this control. Needed by XML config to instantiate it.
		 */
		Legato.Control.Legend.Plugin.QName('LayerVisibility'), {
			_constructor : Legato.Control.Legend.Plugin.LayerVisibility.Factory
		});