/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 70574 $
 */

/**
 * Class: Legato.Beans.Evaluate
 * Evaluates the configured expression an returns the evaluation results.
 */
/*
 * Class: Legato.Beans.Evaluate
 */
Legato.Beans.Evaluate = Legato.Lang.Class({
  /*
   * Property: expression
   * 
   * Expression to evaluate.
   */
  expression : null,
  /*
   * Constructor: initialize
   * 
   * Parameters:
   * 
   * expression - expression to evaluate.
   */
  initialize : function(expression) {
    Legato.Util.Ensure.ensureString(expression);
    this.expression = expression;
  },
  /*
   * Function: getInstance
   * 
   * Returns:
   * 
   * Evaluates the expression and returns the evaluation result;
   * 
   * Parameters:
   * 
   * beanFactory - {<Legato.Beans.BeanFactory>} bean factory.
   */
  getInstance : function(beanFactory) {
    return eval(this.expression);
  }
});

Legato.Beans.Evaluate.Bean = Legato.Beans.Object.Extend('Legato.Beans.Evaluate', Legato.Beans.QName('Evaluate'), {
  _constructor : Legato.Beans.Evaluate,
  constructorArguments : {
    expression : Legato.Lang.String
  },
  constructorOrder : [ 'expression' ]
});