/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

LegatoJQuery.StyleProperties.Factory = OpenLayers
    .Class(Legato.StyleProperties.Factory, {
      initialize : function(options) {
        if(Legato.Lang.ObjectUtils.isNullOrUndefined(jQuery)){
          throw new Legato.Lang.Exception('jQuery is not found');
        }
        Legato.StyleProperties.Factory.prototype.initialize.apply(
          this, [options]
        );
      },

      createSelectElement : function(stylePropertyName, stylePropertyValue,
          style, layer, selectOptions) {
        return new LegatoJQuery.StyleProperties.SelectElement(stylePropertyName,
            stylePropertyValue, style, layer, {
              selectOptions : selectOptions
            });
      },

      createColorElement : function(stylePropertyName, stylePropertyValue,
          style, layer) {
        return new LegatoJQuery.StyleProperties.ColorInputElement(stylePropertyName,
            stylePropertyValue, style, layer);
      },

      CLASS_NAME : 'LegatoJQuery.StyleProperties.Factory'
    });
LegatoJQuery.StyleProperties.Factory.Bean = Legato.Beans.Object.Extend('LegatoJQuery.StyleProperties.Factory',
    LegatoJQuery.StyleProperties.QName('Factory'),
    //
    {
      _constructor : LegatoJQuery.StyleProperties.Factory,
      options : {}
    }
);
