/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

var LegatoJQuery = {
  singleFile : true
};

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 91043 $
 * @requires OpenLayers.js
 */

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 91043 $
 * @requires OpenLayers.js
 */

(function() {
    var singleFile = (typeof LegatoJQuery == "object" && LegatoJQuery.singleFile);
    /**
     * Relative path of this script.
     */
    var scriptName = (!singleFile) ? "lib/LegatoJQuery.js" : "LegatoJQuery.js";
    var jsFiles = window.LegatoJQuery;

    window.LegatoJQuery = {
        _getScriptLocation: (function() {
            var r = new RegExp("(^|(.*?\\/))(" + scriptName + ")(\\?|$)"),
                s = document.getElementsByTagName('script'),
                src, m, l = "";
            for(var i=0, len=s.length; i<len; i++) {
                src = s[i].getAttribute('src');
                if(src) {
                    m = src.match(r);
                    if(m) {
                        l = m[1];
                        break;
                    }
                }
            }
            return (function() { return l; });
        })()
    };

    if(!singleFile) {
      /**
       * PATCH
       */
      //if (!jsFiles) {
      jsFiles = [
       'LegatoJQuery/Control.js',
       'LegatoJQuery/Control/ControlContainer.js',
       'LegatoJQuery/Control/MapResizer.js',
       'LegatoJQuery/Popup.js',
       'LegatoJQuery/Popup/DialogPopup.js',
       'LegatoJQuery/StyleProperties.js',
       'LegatoJQuery/StyleProperties/ColorInputElement.js',
       'LegatoJQuery/StyleProperties/SelectElement.js',
       'LegatoJQuery/StyleProperties/Factory.js'
      ]; // etc.
      /**
       * PATCHJ
       */
      //}

      // use "parser-inserted scripts" for guaranteed execution order
      // http://hsivonen.iki.fi/script-execution/
      var scriptTags = new Array(jsFiles.length);
      var host = LegatoJQuery._getScriptLocation() + "lib/";
      for (var i=0, len=jsFiles.length; i<len; i++) {
          scriptTags[i] = "<script src='" + host + jsFiles[i] +
                                 "'></script>";
      }
      if (scriptTags.length > 0) {
          document.write(scriptTags.join(""));
      }
    }
})();

/**
 * Constant: VERSION_NUMBER
 */
LegatoJQuery.VERSION_NUMBER = "$Revision: 75646 $";
LegatoJQuery.NAMESPACE_URI = 'http://www.disy.net/legatojquery/';
LegatoJQuery.PREFIX = 'ljq';
LegatoJQuery.QName = function(localPart) {
  return new Legato.XML.QName(LegatoJQuery.NAMESPACE_URI, localPart, LegatoJQuery.PREFIX);
};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Revision: 69543 $
 * @requires LegatoJQuery.js
 * @requires OpenLayers/Control.js
 */

/**
 * Class: LegatoJQuery.Control
 * Abstract base class for all Legato control classes
 *
 * Inherits from:
 *  - <OpenLayers.Control>
 */
LegatoJQuery.Control = OpenLayers.Class(OpenLayers.Control, {
  CLASS_NAME : 'LegatoJQuery.Control'
});

/**
 * Space: lc
 * Namespace for Legato controls.
 */
/*
 * URI: Namespace URI
 * {http://www.disy.net/legato/control}
 */
LegatoJQuery.Control.NAMESPACE_URI = 'http://www.disy.net/legatojquery/control';

/*
 * Prefix: Default prefix
 * {ljqc}
 */
LegatoJQuery.Control.PREFIX = 'ljqc';

LegatoJQuery.Control.QName = function(localPart) {
  return new Legato.XML.QName(LegatoJQuery.Control.NAMESPACE_URI, localPart,
      LegatoJQuery.Control.PREFIX);
};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: nedkov $
 * @base Legato.Control
 * @requires Legato/Control.js
 */

/**
 * Class: ControlContainer
 *
 * Inherits from: - <Legato.Control>
 */
LegatoJQuery.Control.ControlContainer = OpenLayers.Class(Legato.Control.ControlContainer,
{

  onHoverPanelDiv : function(panel_div){
    var j_panel_div = jQuery(panel_div);
    if (Legato.Util.Browser.isTouchCapable()){
        j_panel_div.bind('touchstart', function() {
            jQuery(this).children().toggle();
        });
    } else {
      var config = {
          over: function() {
            jQuery(this).children().show();
          },
          timeout: 300,
          out:  function() {
            jQuery(this).children().hide();
          }
      };

      j_panel_div.click(function() {
        jQuery(this).children().show();
      });
      j_panel_div.hoverIntent(config);
    }
  },

  CLASS_NAME: 'LegatoJQuery.Control.ControlContainer'
});

/**
 * Structure: lc:ControlContainer
 * XML based config for a <Legato.Control.ControlContainer>.
 *
 * See Also:
 * - <Legato.Control>
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a ControlContainer would be:
 * (start code)
 * <ljqc:ControlContainer>
 *  <controls>
 *  </controls>
 * </ljqc:ControlContainer>
 * (end)
 */
LegatoJQuery.Control.ControlContainer.Bean = Legato.Control.ControlContainer.Bean.Extend(
    'LegatoJQuery.Control.ControlContainer',
    LegatoJQuery.Control.QName('ControlContainer'),
    {
      _constructor: LegatoJQuery.Control.ControlContainer
    }
  );

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

LegatoJQuery.Control.MapResizer = OpenLayers.Class(OpenLayers.Control, {

  type : OpenLayers.Control.TYPE_TOOL,
  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, [ options ]);
  },
  draw : function() {
    var div = OpenLayers.Control.prototype.draw.apply(this, arguments);
    return div;
  },
  setMap : function(map) {
    OpenLayers.Control.prototype.setMap.apply(this, arguments);
    OpenLayers.Function.bind(jQuery(this.map.div).resizable({
      stop: OpenLayers.Function.bind(this.onMapResized, this)
    }), this);
  },
  onMapResized: function(event, ui){
    this.map.updateSize();
  },
  destroy : function() {
  },
  CLASS_NAME : "LegatoJQuery.Control.MapResizer"
});

/**
 * Component: ljqc:MapResizer
 *
 * The MapResizer control adds resizing capabilities for the OpenLayers map using jQuery.
 *
 * See also:
 * - <ljqc> namespace
 */
LegatoJQuery.Control.MapResizer.Bean = OpenLayers.Control.Bean.Extend(

'LegatoJQuery.Control.MapResizer',

LegatoJQuery.Control.QName('MapResizer'), {
  _constructor : LegatoJQuery.Control.MapResizer,
  options : {
  }
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

LegatoJQuery.Popup = {};

/**
 * Space: ljqpo
 * Namespace for Legato jQuery popups.
 */
/**
 * URI: Namespace URI
 * {http://www.disy.net/legatojquery/popup}
 */
LegatoJQuery.Popup.NAMESPACE_URI = 'http://www.disy.net/legatojquery/popup';
/**
 * Prefix: Default prefix
 * {ljqpo}
 */
LegatoJQuery.Popup.PREFIX = 'ljqpo';
LegatoJQuery.Popup.QName = function(localPart) {
  return new Legato.XML.QName(LegatoJQuery.Popup.NAMESPACE_URI, localPart, LegatoJQuery.Popup.PREFIX);
};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

LegatoJQuery.Popup.DialogPopup = OpenLayers.Class(
  Legato.Popup,
  {
    closeCallback : null,

    initialize: function(options){
      if(Legato.Lang.ObjectUtils.isNullOrUndefined(jQuery)){
        throw new Legato.Lang.Exception('jQuery is not found');
      }
      Legato.Popup.prototype.initialize.apply(
        this, [options]
      );
      this.dialog = jQuery('<div></div>')
      .html('')
      .dialog({
        autoOpen: false,
        close: OpenLayers.Function.bind(this.closeDialog, this)
      });
      this.configureDialog();
    },

    configureDialog: function(){
      this.dialog.dialog( 'option', 'title', this.title );
      if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.maxHeight)){
        this.dialog.dialog( 'option', 'maxHeight', this.maxHeight );
      }

      if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.height)) {
        this.dialog.dialog( 'option', 'height', this.height );
      }

      if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.width)) {
        this.dialog.dialog( 'option', 'width', this.width );
      }


      if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.size)){
        this.dialog.dialog( 'option', 'height', this.size.h );
        this.dialog.dialog( 'option', 'width', this.size.w );
      }

      this.setPosition(this.position);

      if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.zIndex)){
        this.dialog.dialog( 'option', 'zIndex', this.zIndex );
      }
    },

    openUrl : function(url) {
      this.dialog.html("<iframe id='modalIframeId' width='100%' height='100%' marginWidth='0' marginHeight='0' frameBorder='0' scrolling='auto' src='" +
          url
          + "'>Your browser does not support iFrames</iframe>");
      this.dialog.dialog('open');
    },

    open : function(element, id, closeCallback) {
      this.closeCallback = closeCallback;
      if (id !== null) {
        this.dialog.attr('id', id);
      }
      this.dialog.html(element);
      this.dialog.dialog('open');
    },

    close : function() {
      this.dialog.dialog();
      this.dialog.dialog('close');
    },

    closeDialog : function(event) {
      if (Legato.Lang.Function.isInstance(this.closeCallback)) {
        this.closeCallback(event);
      }
    },

    CLASS_NAME : 'LegatoJQuery.Popup.DialogPopup'
  }
);

/**
 * Component: ljqpo:DialogPopup
 *
 * The DialogPopup control creates and displays text or urls using the jQuery library.
 *
 * See also:
 * - <ljqpo> namespace
 */
LegatoJQuery.Popup.DialogPopup.Bean = Legato.Popup.Bean.Extend('LegatoJQuery.Popup.DialogPopup',
LegatoJQuery.Popup.QName('DialogPopup'),
//
{
  _constructor : LegatoJQuery.Popup.DialogPopup
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

LegatoJQuery.StyleProperties = {};

/**
 * Space: ljqui
 * Namespace for Legato jQuery uis.
 */
/**
 * URI: Namespace URI
 * {http://www.disy.net/legatojquery/styleproperties}
 */
LegatoJQuery.StyleProperties.NAMESPACE_URI = 'http://www.disy.net/legatojquery/styleproperties';
/**
 * Prefix: Default prefix
 * {ljqsp}
 */
LegatoJQuery.StyleProperties.PREFIX = 'ljqsp';
LegatoJQuery.StyleProperties.QName = function(localPart) {
  return new Legato.XML.QName(LegatoJQuery.StyleProperties.NAMESPACE_URI, localPart, LegatoJQuery.StyleProperties.PREFIX);
};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

LegatoJQuery.StyleProperties.ColorInputElement = OpenLayers
    .Class(
        Legato.StyleProperties.InputElement,
        {
          createInput : function() {
            var colorInput = Legato.StyleProperties.InputElement.prototype.createInput
                .apply(this, arguments);
            var jColorInput = jQuery(colorInput);
            var that = this;
            jColorInput.colorpicker({
              parts : [ 'map', 'bar', 'rgb', 'alpha', 'swatches', 'preview'],
              select : function(event, color) {
                var propertyValue = '#' + color.formatted;
                that.style[that.propertyName.replace('Color', 'Opacity')]= color.a;
                that.onInputValueChanged(propertyValue);
                that.updateInputElement(jColorInput, propertyValue, color.a);
              },
              open : function(event){
                jColorInput.blur();
              },
              alpha : true
            });
            jColorInput.addClass('StylePropertyColorInput');
            jColorInput.attr('readonly', 'readonly');
            this.updateInputElement(jColorInput, '#' + this.propertyValue, 1);
            return colorInput;
          },
          
          updateInputElement: function(jColorInput, color, opacity){
            jColorInput.css('background', color)
                       .css('border', color)
                       .css('opacity', opacity);
          },

          CLASS_NAME : 'LegatoJQuery.StyleProperties.ColorInputElement'
        });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

LegatoJQuery.StyleProperties.SelectElement = OpenLayers
    .Class(
        Legato.StyleProperties.SelectElement,
        {
          createInput : function() {
            var selectElement = Legato.StyleProperties.SelectElement.prototype.createInput
                .apply(this, arguments);
            var selectElementWrapper = document.createElement('div');
            selectElementWrapper.appendChild(selectElement);
            var jSelectElement = jQuery(selectElement);
            var that = this;
            jSelectElement.combobox({
              selected : function(e, ui) {
                that.onInputValueChanged(ui.item.value);
              }
            });
            return selectElementWrapper;
          },

          CLASS_NAME : 'LegatoJQUery.StyleProperties.SelectElement'
        });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

LegatoJQuery.StyleProperties.Factory = OpenLayers
    .Class(Legato.StyleProperties.Factory, {
      initialize : function(options) {
        if(Legato.Lang.ObjectUtils.isNullOrUndefined(jQuery)){
          throw new Legato.Lang.Exception('jQuery is not found');
        }
        Legato.StyleProperties.Factory.prototype.initialize.apply(
          this, [options]
        );
      },

      createSelectElement : function(stylePropertyName, stylePropertyValue,
          style, layer, selectOptions) {
        return new LegatoJQuery.StyleProperties.SelectElement(stylePropertyName,
            stylePropertyValue, style, layer, {
              selectOptions : selectOptions
            });
      },

      createColorElement : function(stylePropertyName, stylePropertyValue,
          style, layer) {
        return new LegatoJQuery.StyleProperties.ColorInputElement(stylePropertyName,
            stylePropertyValue, style, layer);
      },

      CLASS_NAME : 'LegatoJQuery.StyleProperties.Factory'
    });
LegatoJQuery.StyleProperties.Factory.Bean = Legato.Beans.Object.Extend('LegatoJQuery.StyleProperties.Factory',
    LegatoJQuery.StyleProperties.QName('Factory'),
    //
    {
      _constructor : LegatoJQuery.StyleProperties.Factory,
      options : {}
    }
);

