/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

OpenLayers.Layer.Google.MapType = null;

if (typeof G_NORMAL_MAP != 'undefined') {
  OpenLayers.Layer.Google.MapType = Legato.Beans.Object.Enum(
    'OpenLayers.Layer.Google.MapType', {
      normal : G_NORMAL_MAP,
      satellite : G_SATELLITE_MAP,
      hybrid : G_HYBRID_MAP
    });
} else {
  OpenLayers.Layer.Google.MapType = Legato.Beans.Object.Enum(
      'OpenLayers.Layer.Google.MapType', {
        // empty
      });
}

OpenLayers.Layer.Google.Bean = OpenLayers.Layer.Bean.Extend(
    'OpenLayers.Layer.Google',
    //
    Legato.OpenLayers.Layer.QName('Google'),
    //
    {
      //_constructor :OpenLayers.Layer.Google,
      factoryFunction : function(name, options) {

        if (Legato.Lang.ObjectUtils.exists(options)
            && !Legato.Lang.ObjectUtils.exists(options.sphericalMercator)) {
          options.sphericalMercator = true;
        }
        var layer = new OpenLayers.Layer.Google(name, options);
        return layer;
      },
      constructorArguments : {
        name : Legato.Lang.String
      },
      constructorOrder : [ 'name' ],
      options : {
        type : OpenLayers.Layer.Google.MapType,
        sphericalMercator : Legato.Lang.Boolean
      }
    });

OpenLayers.Layer.Google.LayerFactory = Legato.Lang.Class(
//
    Legato.Format.ExtendedWMC.LayerFactory,
    //
    {
      layerType : OpenLayers.Layer.Google.Bean
    });

Legato.Format.ExtendedWMC.registerDefaultLayerFactory('OL:Google',
    new OpenLayers.Layer.Google.LayerFactory());