/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Layer.GetLegend = Legato.Lang
    .Class( {
      url :null,
      params :null,
      dynamic :true,
      initialize : function(url) {
        Legato.Util.Ensure.ensureString(url);
        var questionMarkIndex = url.indexOf('?');
        if (questionMarkIndex > 0) {
          this.url = url.substring(0, questionMarkIndex);
          this.params = OpenLayers.Util.upperCaseObject(OpenLayers.Util
              .getParameters(url));
        } else {
          this.url = url;
          this.params = {};
        }
      },
      getURL : function(layer) {
        Legato.Util.Ensure.ensureExists(layer);
        var params = OpenLayers.Util.extend( {}, this.params);
        var bounds = layer.map.getExtent();
        if (Legato.Lang.ObjectUtils.exists(bounds)) {
          params.BBOX = bounds.toArray();
        }

        var size = layer.map.getSize();
        if (Legato.Lang.ObjectUtils.exists(size)) {
          params.WIDTH = size.w;
          params.HEIGHT = size.h;
        }

        var projection = layer.map.getProjection();
        if (Legato.Lang.ObjectUtils.exists(projection) && projection != 'none') {
          params.SRS = projection;
        }

        params.LAYERS = Legato.Lang.ObjectUtils.exists(layer.layerId) ? layer.layerId
            : layer.name;

        var url = this.url + '?' + OpenLayers.Util.getParameterString(params);
        return url;
      },
      CLASS_NAME :'Legato.Layer.GetLegend'
    });