/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ogc.gml.v_3_1_1.jts;

import com.vividsolutions.jts.geom.LineString;
import javax.xml.bind.JAXBElement;
import net.opengis.gml.v_3_1_1.DirectPositionType;
import net.opengis.gml.v_3_1_1.LineStringPropertyType;
import net.opengis.gml.v_3_1_1.LineStringType;
import org.jvnet.ogc.gml.v_3_1_1.ObjectFactoryInterface;
import org.jvnet.ogc.gml.v_3_1_1.jts.AbstractJTSToGML311Converter;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311CoordinateConverter;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311SRSReferenceGroupConverterInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTSToGML311LineStringConverter
extends AbstractJTSToGML311Converter<LineStringType, LineStringPropertyType, LineString> {
    private final JTSToGML311CoordinateConverter coordinateConverter;

    public JTSToGML311LineStringConverter(ObjectFactoryInterface objectFactory, JTSToGML311SRSReferenceGroupConverterInterface srsReferenceGroupConverter, JTSToGML311CoordinateConverter coordinateConverter) {
        super(objectFactory, srsReferenceGroupConverter);
        this.coordinateConverter = coordinateConverter;
    }

    @Override
    protected LineStringType doCreateGeometryType(LineString lineString) {
        LineStringType resultLineString = this.getObjectFactory().createLineStringType();
        for (DirectPositionType directPosition : this.coordinateConverter.convertCoordinates(lineString.getCoordinates())) {
            JAXBElement<DirectPositionType> pos = this.getObjectFactory().createPos(directPosition);
            resultLineString.getPosOrPointPropertyOrPointRep().add(pos);
        }
        return resultLineString;
    }

    @Override
    public LineStringPropertyType createPropertyType(LineString lineString) {
        LineStringPropertyType lineStringPropertyType = this.getObjectFactory().createLineStringPropertyType();
        lineStringPropertyType.setLineString((LineStringType)this.createGeometryType(lineString));
        return lineStringPropertyType;
    }

    @Override
    public JAXBElement<LineStringType> createElement(LineString linearString) {
        return this.getObjectFactory().createLineString((LineStringType)this.createGeometryType(linearString));
    }
}

