/*
 * Decompiled with CFR 0.152.
 */
package net.disy.legato.tools.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Point;
import java.text.MessageFormat;
import net.disy.legato.tools.jts.AbstractGeometryConverter;
import org.directwebremoting.extend.MarshallException;

public class PointConverter
extends AbstractGeometryConverter<Point, double[]> {
    @Override
    protected String getGeometryType() {
        return "Point";
    }

    @Override
    protected Class<double[]> getCoordinatesType() {
        return double[].class;
    }

    @Override
    public double[] createCoordinates(Point point) throws MarshallException {
        if (point == null) {
            return null;
        }
        if (point.isEmpty()) {
            return new double[0];
        }
        double x = point.getCoordinate().x;
        double y = point.getCoordinate().y;
        double z = point.getCoordinate().z;
        if (Double.isNaN(z)) {
            return new double[]{x, y};
        }
        return new double[]{x, y, z};
    }

    @Override
    public Point createGeometry(double[] coordinates) throws MarshallException {
        if (coordinates == null) {
            return null;
        }
        if (coordinates.length == 2) {
            return this.getGeometryFactory().createPoint(new Coordinate(coordinates[0], coordinates[1]));
        }
        if (coordinates.length == 3) {
            return this.getGeometryFactory().createPoint(new Coordinate(coordinates[0], coordinates[1], coordinates[2]));
        }
        throw new MarshallException(Point.class, MessageFormat.format("Incorrect number of coordinate components [{0}].", coordinates.length));
    }
}

