/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.proxy;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.disy.commons.httpclient.methods.MarshallingRequestEntity;
import net.disy.ogc.wps.v_1_0_0.proxy.ProxyConfig;
import net.disy.ogc.wps.v_1_0_0.proxy.WPSConnectionException;
import net.disy.ogc.wps.v_1_0_0.proxy.WPSMarshallingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;

public class GenericMarshallingHttpClient {
    private static final String FILE_PROTOCOL = "file:";
    private final DefaultHttpClient httpClient;
    private DefaultHttpClient defaultHttpProxyClient;
    private final JAXBContext jaxbContext;
    private final Log log = LogFactory.getLog(this.getClass());
    private Map<String, ProxyConfig> multiHostProxyConfig;
    private List<String> excludedHostConfig;

    public GenericMarshallingHttpClient(JAXBContext jaxbContext) {
        this.httpClient = this.getHttpClientByConfig(null);
        this.jaxbContext = jaxbContext;
    }

    public Object executeFullyParametrizedGetRequest(String url) throws WPSConnectionException, WPSMarshallingException {
        this.log.debug((Object)MessageFormat.format("Executing GET request: [{0}]", url));
        if (url.startsWith(FILE_PROTOCOL)) {
            this.log.warn((Object)MessageFormat.format("[{0}] is a file URL, we are not using httpclient", url));
            try {
                StreamSource input = new StreamSource(new File(new URI(url)));
                return this.unmarshal(input);
            }
            catch (URISyntaxException e) {
                throw new WPSConnectionException(e);
            }
            catch (JAXBException e) {
                throw new WPSMarshallingException(e);
            }
        }
        HttpGet method = new HttpGet(url);
        return this.executeAnUnmarshal((HttpRequestBase)method);
    }

    private Object executeAnUnmarshal(HttpRequestBase method) throws WPSConnectionException, WPSMarshallingException {
        URI uri = null;
        try {
            uri = method.getURI();
            HttpResponse httpResponse = this.getHttpClientByHost(uri.getHost()).execute((HttpUriRequest)method);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != -1) {
                InputStream responseStream = httpResponse.getEntity().getContent();
                StreamSource source = new StreamSource(responseStream);
                Object result = this.unmarshal(source);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Received XML:");
                    this.logJaxb(result);
                }
                Object object = result;
                return object;
            }
            Object var5_8 = null;
            return var5_8;
        }
        catch (IOException e) {
            throw new WPSConnectionException(MessageFormat.format("Internal IOException by the URI [{0}]: {1}", uri == null ? "" : uri.toString(), e.getMessage()), e);
        }
        catch (JAXBException e) {
            throw new WPSMarshallingException(MessageFormat.format("Internal JAXBException by the URI [{0}]: {1}", uri == null ? "" : uri.toString(), e.getMessage()), e);
        }
        finally {
            method.releaseConnection();
        }
    }

    private Object unmarshal(Source source) throws JAXBException {
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        Object result = unmarshaller.unmarshal(source);
        return result;
    }

    private void logJaxb(Object objToLog) throws JAXBException {
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter result = new StringWriter();
        marshaller.marshal(objToLog, (Writer)result);
        this.log.debug((Object)result.getBuffer().toString());
    }

    public Object executePostRequest(String url, Object input) throws Exception {
        HttpPost method;
        this.log.debug((Object)("Executing POST request on URL: [" + url + "] and with input " + input));
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            method = new HttpPost(url);
            MarshallingRequestEntity entity = new MarshallingRequestEntity(marshaller, input);
            method.setEntity((HttpEntity)entity);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Sending XML");
                this.logJaxb(input);
            }
        }
        catch (JAXBException e) {
            throw new Exception("Internal JAXB Exception: " + e.getMessage(), e);
        }
        return this.executeAnUnmarshal((HttpRequestBase)method);
    }

    public void setDefaultProxyConfig(ProxyConfig defaultProxyConfig) {
        if (defaultProxyConfig != null) {
            this.defaultHttpProxyClient = this.getHttpClientByConfig(defaultProxyConfig);
        }
    }

    public void setMultiHostProxyConfig(Map<String, ProxyConfig> multiProxyHostConfig) {
        this.multiHostProxyConfig = multiProxyHostConfig;
    }

    public void setExcludedHostConfig(List<String> excludedHostConfig) {
        this.excludedHostConfig = excludedHostConfig;
    }

    private DefaultHttpClient getHttpClientByConfig(ProxyConfig proxyConfig) {
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)new PoolingClientConnectionManager());
        client.getParams().setIntParameter("http.connection.timeout", 30000);
        if (proxyConfig == null) {
            return client;
        }
        HttpHost proxyHost = new HttpHost(proxyConfig.getHost(), proxyConfig.getPort());
        client.getParams().setParameter("http.route.default-proxy", (Object)proxyHost);
        return client;
    }

    private HttpClient getHttpClientByHost(String host) {
        if (this.multiHostProxyConfig != null && this.multiHostProxyConfig.containsKey(host)) {
            return this.getHttpClientByConfig(this.multiHostProxyConfig.get(host));
        }
        if (this.excludedHostConfig != null && this.excludedHostConfig.contains(host)) {
            return this.httpClient;
        }
        if (this.defaultHttpProxyClient != null) {
            return this.defaultHttpProxyClient;
        }
        return this.httpClient;
    }
}

