/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.proxy;

import net.disy.ogc.ows.v_1_1_0.NoApplicableCodeException;
import net.disy.ogc.ows.v_1_1_0.OwsException;
import net.opengis.ows.v_1_1_0.ExceptionReport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExceptionHandlingUtils {
    private static Log log = LogFactory.getLog(ExceptionHandlingUtils.class);

    public static <T> T handleExceptionReport(Object responseObject, Class<T> expectedType) throws OwsException {
        if (expectedType.isAssignableFrom(responseObject.getClass())) {
            return (T)responseObject;
        }
        if (responseObject instanceof ExceptionReport) {
            ExceptionReport exceptionReport = (ExceptionReport)responseObject;
            log.warn((Object)("Remote process returned an exception report: " + exceptionReport));
            OwsException wrapperException = new OwsException(exceptionReport);
            throw wrapperException;
        }
        log.error((Object)("Seeing unexpected response class: " + responseObject.getClass()));
        throw new NoApplicableCodeException("Unexpected response class: " + responseObject.getClass());
    }
}

