/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.httpclient.methods;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.Validate;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.message.BasicHeader;

public class MarshallingRequestEntity
extends AbstractHttpEntity
implements HttpEntity {
    private final Marshaller marshaller;
    private final Object object;
    private final String contentType;
    private final String charset;
    private final byte[] bytes;

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public Object getObject() {
        return this.object;
    }

    public Header getContentType() {
        BasicHeader header = new BasicHeader("Content-type", this.contentType);
        return header;
    }

    public String getCharset() {
        return this.charset;
    }

    public MarshallingRequestEntity(Marshaller marshaller, Object object) throws JAXBException {
        this(marshaller, object, "application/xml", "UTF-8");
    }

    public MarshallingRequestEntity(Marshaller marshaller, Object object, String contentType, String charset) throws JAXBException {
        Validate.notNull((Object)marshaller);
        Validate.notNull((Object)object);
        Validate.notNull((Object)contentType);
        Validate.notNull((Object)charset);
        this.object = object;
        this.marshaller = marshaller;
        this.contentType = contentType;
        this.charset = charset;
        this.bytes = this.createBytes();
    }

    public long getContentLength() {
        return this.bytes.length;
    }

    public boolean isRepeatable() {
        return false;
    }

    protected byte[] createBytes() throws JAXBException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, this.getCharset());
            StreamResult result = new StreamResult(writer);
            this.getMarshaller().marshal(this.getObject(), (Result)result);
            return out.toByteArray();
        }
        catch (UnsupportedEncodingException ueex) {
            throw new RuntimeException(ueex);
        }
    }

    @Deprecated
    public void consumeContent() throws IOException {
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        return null;
    }

    public boolean isChunked() {
        return false;
    }

    public boolean isStreaming() {
        return false;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.bytes);
    }
}

