/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.sample.rips;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import net.disy.ogc.wps.v_1_0_0.util.UnreachableCodeReachedException;
import net.disy.ogc.wpspd.v_1_0_0.Link;
import net.disy.ogc.wpspd.v_1_0_0.LinkType;
import net.disy.ogc.wpspd.v_1_0_0.Message;
import net.disy.ogc.wpspd.v_1_0_0.MessageType;
import net.disy.ogc.wpspd.v_1_0_0.ObjectFactory;
import net.disy.ogc.wpspd.v_1_0_0.WpspdUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpParams;

public abstract class AbstractRipsProcessToWpsAdapter {
    protected static Log logger = LogFactory.getLog(AbstractRipsProcessToWpsAdapter.class);
    private static final String PARAMETER_COORDINATES = "coord";
    private static final String PARAMETER_TYPE = "type";
    private static final String PARAMETER_ID = "id";
    private static final String PARAMETER_REQUEST = "request";
    private static final String REQUEST_TYPE_EXECUTE = "execute";
    private static String RESULT_ELEMENT_NAME = "result";
    private static String TEXT_ELEMENT_NAME = "text";
    private static String ERROR_ELEMENT_NAME = "error";

    protected Link executeWithLinkResult(String serviceId, Geometry geometry) {
        String baseUrl = this.getBaseUrl();
        String type = this.getType(geometry);
        String coordinateString = this.getCoordinateString(geometry);
        String url = MessageFormat.format("{0}?{1}={2}&{3}={4}&{5}={6}&{7}={8}", baseUrl, PARAMETER_REQUEST, REQUEST_TYPE_EXECUTE, PARAMETER_ID, serviceId, PARAMETER_TYPE, type, PARAMETER_COORDINATES, coordinateString);
        logger.debug((Object)("URL: " + url));
        ObjectFactory objectFactory = WpspdUtils.createObjectFactory();
        LinkType link = objectFactory.createLinkType();
        link.setHref(url);
        link.setShow("new");
        return objectFactory.createLink(link);
    }

    private HttpRequestBase createGetMethod(String serviceId, Geometry geometry) {
        NameValuePair[] requestParameters;
        String baseUri = this.getBaseUrl();
        HttpGet method = new HttpGet(baseUri);
        HttpParams params = method.getParams();
        for (NameValuePair requestParameter : requestParameters = this.createRequestParameters(serviceId, geometry)) {
            params.setParameter(requestParameter.getName(), (Object)requestParameter.getValue());
        }
        return method;
    }

    private String getBaseUrl() {
        String pattern = "http://rips-dienste.lubw.baden-wuerttemberg.de/rips/ripsweb.webservices/RipsServicesProvider.aspx";
        return pattern;
    }

    private NameValuePair[] createRequestParameters(String serviceId, Geometry geometry) {
        String type = this.getType(geometry);
        String coordinateString = this.getCoordinateString(geometry);
        return new NameValuePair[]{new BasicNameValuePair(PARAMETER_REQUEST, REQUEST_TYPE_EXECUTE), new BasicNameValuePair(PARAMETER_ID, serviceId), new BasicNameValuePair(PARAMETER_TYPE, type), new BasicNameValuePair(PARAMETER_COORDINATES, coordinateString)};
    }

    private String getType(Geometry geometry) {
        if (geometry instanceof Point) {
            return "point";
        }
        if (geometry instanceof LineString) {
            return "polyline";
        }
        throw new IllegalArgumentException("Type '" + geometry.getGeometryType() + "' is not supported.");
    }

    private String getCoordinateString(Geometry geometry) {
        boolean first = true;
        StringBuffer coordinateBuffer = new StringBuffer();
        for (Coordinate coordinate : geometry.getCoordinates()) {
            if (!first) {
                coordinateBuffer.append("|");
            }
            coordinateBuffer.append(coordinate.x + ";" + coordinate.y);
            first = false;
        }
        try {
            return URLEncoder.encode(coordinateBuffer.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnreachableCodeReachedException();
        }
    }

    private Message createMessage(String content, String type) {
        ObjectFactory objectFactory = WpspdUtils.createObjectFactory();
        MessageType message = objectFactory.createMessageType();
        message.setContent((Object)content);
        message.setType(type);
        return objectFactory.createMessage(message);
    }
}

