/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.sample;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import net.disy.ogc.ows.v_1_1_0.InvalidParameterValueException;
import net.disy.ogc.wps.v_1_0_0.annotation.DataType;
import net.disy.ogc.wps.v_1_0_0.annotation.InputParameter;
import net.disy.ogc.wps.v_1_0_0.annotation.OutputParameter;
import net.disy.ogc.wps.v_1_0_0.annotation.Process;
import net.disy.ogc.wps.v_1_0_0.annotation.ProcessMethod;

@Process(id="dummyHeightForMultiPoint", title="Dummy Height for Multipoint Service", description="Sets the given height for all points inside this MultiPoint")
public class DummyHeightForMultiPoint {
    @ProcessMethod
    @OutputParameter(id="setHeightForMultiPoint", title="Set height for MultiPoint", description="Sets the given height for all points inside this MultiPoint", dataType=@DataType(schemaDesignator="http://schemas.opengis.net/gml/3.1.1/base/gml.xsd#MultiPoint"))
    public MultiPoint setHeightForMultiPoint(@InputParameter(id="multipoint", title="2D Points", description="A selection of points where you want to define the height") MultiPoint multipoint, @InputParameter(id="height", title="Height", description="The height value") Double height) throws InvalidParameterValueException {
        if (height < 0.0) {
            throw new InvalidParameterValueException("Given height parameter value needs to be >= 0", String.valueOf(height));
        }
        ArrayList<Point> transformedPoints = new ArrayList<Point>();
        for (Coordinate coordinate : multipoint.getCoordinates()) {
            coordinate = new Coordinate(coordinate.x, coordinate.y, height.doubleValue());
            transformedPoints.add(multipoint.getFactory().createPoint(coordinate));
        }
        MultiPoint transformedMultiPoint = new MultiPoint(transformedPoints.toArray(new Point[transformedPoints.size()]), multipoint.getFactory());
        return transformedMultiPoint;
    }
}

