/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.procedure;

import net.disy.ogc.wps.v_1_0_0.model.DataType;
import net.disy.ogc.wps.v_1_0_0.model.FormatId;
import net.disy.ogc.wps.v_1_0_0.procedure.WpsProcessContext;
import net.opengis.ows.v_1_1_0.DomainMetadataType;
import net.opengis.wps.v_1_0_0.ComplexDataCombinationType;
import net.opengis.wps.v_1_0_0.ComplexDataCombinationsType;
import net.opengis.wps.v_1_0_0.ComplexDataDescriptionType;
import net.opengis.wps.v_1_0_0.SupportedComplexDataType;

public abstract class AbstractDataInputOutputBuilder {
    private final WpsProcessContext context;

    public AbstractDataInputOutputBuilder(WpsProcessContext context) {
        this.context = context;
    }

    public WpsProcessContext getContext() {
        return this.context;
    }

    protected void addDataCombinations(DataType<?> dataType, SupportedComplexDataType complexType) {
        ComplexDataCombinationType combinationType = this.context.getWpsObjectFactory().createComplexDataCombinationType();
        complexType.setDefault(combinationType);
        ComplexDataDescriptionType format = this.context.getWpsObjectFactory().createComplexDataDescriptionType();
        combinationType.setFormat(format);
        ComplexDataCombinationsType combinationsType = this.context.getWpsObjectFactory().createComplexDataCombinationsType();
        complexType.setSupported(combinationsType);
        combinationsType.getFormat().add(format);
        FormatId formatId = this.context.getFormatRegistry().getDefaultFormat(dataType).getFormatId();
        format.setEncoding(formatId.getEncoding());
        format.setMimeType(formatId.getMimeType());
        format.setSchema(formatId.getSchemaDesignator());
    }

    protected DomainMetadataType getMetaDataType(DataType<?> dataType) {
        DomainMetadataType metadataType = this.context.getOwsObjectFactory().createDomainMetadataType();
        metadataType.setValue(dataType.getSchemaDesignator());
        return metadataType;
    }
}

