/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.converter;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBElement;
import net.disy.ogc.wps.v_1_0_0.converter.AbstractConverter;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.lang.StringUtils;

public class SingleItemTypeConverter<D>
extends AbstractConverter<List<Object>, D> {
    private final Class<D> destinationClass;

    public SingleItemTypeConverter(Class<D> destinationClass) {
        this.destinationClass = destinationClass;
    }

    @Override
    protected List<Object> convertFromNotNull(D source) {
        return Collections.singletonList(source);
    }

    @Override
    protected D convertToNotNull(List<Object> source) {
        Collection sourceWithoutWhitespaceStrings = CollectionUtils.select(source, (Predicate)new Predicate<Object>(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                if (object instanceof String) {
                    return !StringUtils.isWhitespace((String)((String)object));
                }
                return true;
            }
        });
        if (sourceWithoutWhitespaceStrings.size() != 1) {
            throw new IllegalArgumentException("Source list must have exactly one JAXB element.");
        }
        Object item = sourceWithoutWhitespaceStrings.iterator().next();
        Class<?> itemClass = item.getClass();
        if (this.destinationClass.isAssignableFrom(itemClass)) {
            Object result = item;
            return (D)result;
        }
        if (item instanceof JAXBElement) {
            JAXBElement element = (JAXBElement)item;
            Object value = element.getValue();
            if (this.destinationClass.isAssignableFrom(value.getClass())) {
                Object result = value;
                return (D)result;
            }
            throw new IllegalArgumentException(MessageFormat.format("Source list is a JAXB element and its value is of the wrong type [{0}].", value.getClass().getName()));
        }
        throw new IllegalArgumentException(MessageFormat.format("Source list has an element of the wrong type [{0}].", itemClass.getName()));
    }

    @Override
    public Class<D> getDestinationClass() {
        return this.destinationClass;
    }

    @Override
    public Class<List<Object>> getSourceClass() {
        Class<List> theClass;
        Class<List> sourceClass = theClass = List.class;
        return sourceClass;
    }
}

