/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.disy.ogc.wps.v_1_0_0.GetCapabilitiesService;
import net.disy.ogc.wps.v_1_0_0.WpsProcess;
import net.disy.ogc.wps.v_1_0_0.WpsProcessRegistry;
import net.opengis.ows.v_1_1_0.OperationsMetadata;
import net.opengis.ows.v_1_1_0.ServiceIdentification;
import net.opengis.ows.v_1_1_0.ServiceProvider;
import net.opengis.wps.v_1_0_0.GetCapabilities;
import net.opengis.wps.v_1_0_0.Languages;
import net.opengis.wps.v_1_0_0.LanguagesType;
import net.opengis.wps.v_1_0_0.ProcessBriefType;
import net.opengis.wps.v_1_0_0.ProcessDescriptionType;
import net.opengis.wps.v_1_0_0.ProcessOfferings;
import net.opengis.wps.v_1_0_0.WPSCapabilitiesType;

public class DefaultGetCapabilitiesService
implements GetCapabilitiesService {
    private WpsProcessRegistry wpsProcessRegistry;
    private ServiceIdentification serviceIdentification;
    private ServiceProvider serviceProvider;
    private Locale defaultLanguage = Locale.ENGLISH;
    private Collection<Locale> supportedLanguages = Collections.singletonList(Locale.ENGLISH);
    private OperationsMetadata operationsMetadata;

    public WpsProcessRegistry getWpsProcessRegistry() {
        return this.wpsProcessRegistry;
    }

    public void setWpsProcessRegistry(WpsProcessRegistry wpsProcessRegistry) {
        this.wpsProcessRegistry = wpsProcessRegistry;
    }

    public ServiceIdentification getServiceIdentification() {
        return this.serviceIdentification;
    }

    public void setServiceIdentification(ServiceIdentification serviceIdentification) {
        this.serviceIdentification = serviceIdentification;
    }

    public ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    public void setServiceProvider(ServiceProvider serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    public Locale getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(Locale defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public Collection<Locale> getSupportedLanguages() {
        return this.supportedLanguages;
    }

    public void setSupportedLanguages(Collection<Locale> supportedLanguages) {
        this.supportedLanguages = supportedLanguages;
    }

    @Override
    public WPSCapabilitiesType execute(GetCapabilities input) {
        ServiceProvider currentServiceProvider;
        WPSCapabilitiesType wpsCapabilities = new WPSCapabilitiesType();
        wpsCapabilities.setVersion("1.0.0");
        wpsCapabilities.setService("WPS");
        ServiceIdentification currentServiceIdentification = this.getServiceIdentification();
        if (currentServiceIdentification != null) {
            wpsCapabilities.setServiceIdentification(currentServiceIdentification);
        }
        if ((currentServiceProvider = this.getServiceProvider()) != null) {
            wpsCapabilities.setServiceProvider(currentServiceProvider);
        }
        wpsCapabilities.setOperationsMetadata(this.getOperationsMetadata());
        wpsCapabilities.setProcessOfferings(this.getProcessOfferings());
        wpsCapabilities.setLanguages(this.getLanguages());
        if (this.getDefaultLanguage() != null) {
            wpsCapabilities.setLang(this.getDefaultLanguage().toString());
        }
        return wpsCapabilities;
    }

    public OperationsMetadata getOperationsMetadata() {
        return this.operationsMetadata;
    }

    public void setOperationsMetadata(OperationsMetadata operationsMetadata) {
        this.operationsMetadata = operationsMetadata;
    }

    private ProcessOfferings getProcessOfferings() {
        ProcessOfferings processOfferings = new ProcessOfferings();
        for (WpsProcess wpsProcess : this.getWpsProcessRegistry().getProcesses()) {
            List metadata;
            ProcessDescriptionType processDescription = wpsProcess.getProcessDescription();
            ProcessBriefType briefProcessDescription = new ProcessBriefType();
            if (processDescription.getIdentifier() != null) {
                briefProcessDescription.setIdentifier(processDescription.getIdentifier());
            }
            if (processDescription.getTitle() != null) {
                briefProcessDescription.setTitle(processDescription.getTitle());
            }
            if (processDescription.getAbstract() != null) {
                briefProcessDescription.setAbstract(processDescription.getAbstract());
            }
            if (!(metadata = processDescription.getMetadata()).isEmpty()) {
                briefProcessDescription.getMetadata().addAll(metadata);
            }
            if (!processDescription.getProfile().isEmpty()) {
                briefProcessDescription.getProfile().addAll(processDescription.getProfile());
            }
            if (processDescription.getWSDL() != null) {
                briefProcessDescription.setWSDL(processDescription.getWSDL());
            }
            if (processDescription.getProcessVersion() != null) {
                briefProcessDescription.setProcessVersion(processDescription.getProcessVersion());
            }
            processOfferings.getProcess().add(briefProcessDescription);
        }
        return processOfferings;
    }

    private Languages getLanguages() {
        Languages languages = new Languages();
        if (this.getDefaultLanguage() != null) {
            Languages.Default newDefaultLanguage = new Languages.Default();
            newDefaultLanguage.setLanguage(this.getDefaultLanguage().toString());
            languages.setDefault(newDefaultLanguage);
        }
        if (this.getSupportedLanguages() != null) {
            LanguagesType newSupportedLanguages = new LanguagesType();
            for (Locale locale : this.getSupportedLanguages()) {
                newSupportedLanguages.getLanguage().add(locale.toString());
            }
            languages.setSupported(newSupportedLanguages);
        }
        return languages;
    }
}

