/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.disy.ogc.ows.v_1_1_0.InvalidParameterValueException;
import net.disy.ogc.ows.v_1_1_0.MissingParameterValueException;
import net.disy.ogc.ows.v_1_1_0.OwsException;
import net.disy.ogc.ows.v_1_1_0.util.OwsUtils;
import net.disy.ogc.wps.v_1_0_0.DescribeProcessService;
import net.disy.ogc.wps.v_1_0_0.WpsProcess;
import net.disy.ogc.wps.v_1_0_0.WpsProcessRegistry;
import net.opengis.ows.v_1_1_0.CodeType;
import net.opengis.wps.v_1_0_0.DescribeProcess;
import net.opengis.wps.v_1_0_0.ProcessDescriptions;

public class DefaultDescribeProcessService
implements DescribeProcessService {
    private WpsProcessRegistry wpsProcessRegistry;
    private Locale defaultLanguage;

    public WpsProcessRegistry getWpsProcessRegistry() {
        return this.wpsProcessRegistry;
    }

    public void setWpsProcessRegistry(WpsProcessRegistry wpsProcessRegistry) {
        this.wpsProcessRegistry = wpsProcessRegistry;
    }

    public Locale getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(Locale defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    @Override
    public ProcessDescriptions execute(DescribeProcess request) throws OwsException {
        List identifiers = request.getIdentifier();
        if (identifiers.isEmpty()) {
            throw new MissingParameterValueException("identifier");
        }
        ArrayList<WpsProcess> processes = new ArrayList<WpsProcess>(identifiers.size());
        for (CodeType identifier : identifiers) {
            if (identifier.getCodeSpace() == null && "ALL".equals(identifier.getValue())) {
                processes.addAll(this.getWpsProcessRegistry().getProcesses());
                continue;
            }
            WpsProcess process = this.getWpsProcessRegistry().getProcessByIdentifier(identifier);
            if (process == null) {
                throw new InvalidParameterValueException("identifier", OwsUtils.toString(identifier));
            }
            processes.add(process);
        }
        ProcessDescriptions response = new ProcessDescriptions();
        response.setService("WPS");
        response.setVersion("1.0.0");
        if (this.getDefaultLanguage() != null) {
            response.setLang(this.getDefaultLanguage().toString());
        }
        for (WpsProcess process : processes) {
            response.getProcessDescription().add(process.getProcessDescription());
        }
        return response;
    }
}

