/*
 * Decompiled with CFR 0.152.
 */
package net.disy.legato.tools.jts;

import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.text.MessageFormat;
import net.disy.legato.tools.jts.AbstractGeometryConverter;
import net.disy.legato.tools.jts.PolygonConverter;
import org.directwebremoting.extend.MarshallException;

public class MultiPolygonConverter
extends AbstractGeometryConverter<MultiPolygon, double[][][][]> {
    private final PolygonConverter converter = new PolygonConverter();

    @Override
    protected String getGeometryType() {
        return "MultiPolygon";
    }

    @Override
    protected Class<double[][][][]> getCoordinatesType() {
        return double[][][][].class;
    }

    @Override
    protected double[][][][] createCoordinates(MultiPolygon geometry) throws MarshallException {
        if (geometry == null) {
            return null;
        }
        if (geometry.isEmpty()) {
            return new double[0][0][0][0];
        }
        double[][][][] coordinates = new double[geometry.getNumGeometries()][][][];
        for (int index = 0; index < coordinates.length; ++index) {
            coordinates[index] = this.converter.createCoordinates((Polygon)geometry.getGeometryN(index));
        }
        return coordinates;
    }

    @Override
    protected MultiPolygon createGeometry(double[][][][] coordinates) throws MarshallException {
        if (coordinates == null) {
            return null;
        }
        if (coordinates.length > 0) {
            Polygon[] geometries = new Polygon[coordinates.length];
            for (int index = 0; index < coordinates.length; ++index) {
                geometries[index] = this.converter.createGeometry(coordinates[index]);
            }
            return this.getGeometryFactory().createMultiPolygon(geometries);
        }
        throw new MarshallException(MultiPolygon.class, MessageFormat.format("Incorrect number of coordinate components [{0}].", coordinates.length));
    }
}

