/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: WPS.Control.ToggleWpsForm
 *
 * Switches WPS form on and off
 *
 * Inherits from:
 * - <Legato.Control>
 *
 */
WPS.Control.ToggleWpsForm = OpenLayers.Class(WPS.Control, {

  type :OpenLayers.Control.TYPE_TOGGLE,
  form: null,
  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, arguments);
    if (Legato.Lang.ObjectUtils.exists(this.form)) {
      this.form.events.on({
        'processSelectionCancellation': this.deactivate,
        scope: this
      });
      this.form.events.on({
        'on': this.activate,
        scope: this
      });
      this.form.events.on({
        'off': this.deactivate,
        scope: this
      });
    }
  },

  destroy: function() {
    if (Legato.Lang.ObjectUtils.exists(this.form)) {
      this.form.events.un({
        'processSelectionCancellation': this.deactivate,
        scope: this
      });
      this.form.events.un({
        'on': this.activate,
        scope: this
      });
      this.form.events.un({
        'off': this.deactivate,
        scope: this
      });
    }
    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },


  /** Function: activate
   * Invoked when the control is activated in toggle mode
   */
  activate: function() {
    if (Legato.Lang.ObjectUtils.exists(this.form) && (this.form.isOn === false)) {
      this.form.on();
    }
    WPS.Control.prototype.activate.apply(this, arguments);
  },

  /** Function: deactivate
   * Invoked when the control is deactivated in toggle mode
   */
  deactivate: function() {
    if (Legato.Lang.ObjectUtils.exists(this.form) && (this.form.isOn === true)) {
      this.form.off();
    }
    WPS.Control.prototype.deactivate.apply(this, arguments);
  },

  CLASS_NAME :"WPS.Control.ToggleWpsForm"
});

/**
 * Structure: wpc:ToggleWpsForm
 * XML based config for a <WPS.Control.ToggleWpsForm>.
 *
 * See Also:
 * - <Legato.Control>
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a ToggleDiv would be:
 * (start code)
 * <lwpsc:ToggleWpsForm>
 * <form>
 * <lb:Reference target="WpsForm" />
 * </form>
 * </lwpsc:ToggleWpsForm>
 * (end)
 */
WPS.Control.ToggleWpsForm.Bean = WPS.Control.Bean.Extend(
  'WPS.Control.ToggleWpsForm',
  //
  WPS.Control.QName('ToggleWpsForm'),
  //
  {
    _constructor : WPS.Control.ToggleWpsForm,
    options:
    {
      form: WPS.Form
    }
});
