/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Component.Literal = OpenLayers.Class( WPS.Component.AbstractInput, {
  input :null,

  initializeInputs : function() {
    if (this.input === null) {
      // A Literal input component is special in that it will either render a
      // normal text field or a combobox.
      // The combobox will automatically be chosen based on whether an
      // AllowedValues constraint exists or not for the literal.
      if (this.model.allowedValues === null) {
        this.input = document.createElement('input');
        this.input.type = 'text';
      } else {
        this.input = document.createElement('select');
        for (var i = 0; i < this.model.allowedValues.length; i++) {
          var option = document.createElement('option');
          // WARNING: You have to call appendChild before trying to set the properties (IMPORTANT for IE)
          this.input.appendChild(option);
          option.text = this.model.allowedValues[i];
          if (i === 0) {
            // if we don't set the first element as selected, it will still be visible as if it _was_ selected but the value would not actually be set
            option.selected = true;
            this.onInputValueChange();
          }
        }
      }
      this.container.appendChild(this.input);
    }
    this.input.onchange = OpenLayers.Function.bindAsEventListener(
        this.onInputValueChange, this);
    this.input.onfocus = OpenLayers.Function.bindAsEventListener(
        this.onInputActivated, this);
    return this.input;
  },

  isDropdown : function() {
    return (this.input === null ? false : this.input.nodeName === 'SELECT');
  },

  getValue : function() {
    if (this.isDropdown()) {
      // TODO: investigate whether this should be ".text" or ".value"
      return this.input.options[this.input.selectedIndex].text;
    } else {
      return this.input.value;
    }
  },

  setValue : function(newValue) {
    if (this.isDropdown()) {
      for (var i = 0; i < this.input.children.length; i++) {
        var option = this.input.children[i];
        if (option.value === newValue) {
          option.selected = true;
          break;
        }
      }
    } else {
      this.input.value = newValue;
    }
  },

  onInputValueChange : function() {
    var value = this.getValue();
    this.model.setValue( {
      value :value, /* TODO uom */
      uom :null
    });
  },

  onInputActivated : function() {
    this.onActivation(true);
  },

  onModelValueChange : function(event) {
    this.setValue(event.value.value ? event.value.value : '');
    // TODO uom
  },

  destroy : function() {
    WPS.Component.prototype.destroy.apply(this, arguments);
    if (Legato.Lang.ObjectUtils.exists(this.input)) {
      this.input.onchange = null;
      this.input = null;
    }
  },

  onDeactivation: function() {
    WPS.Component.prototype.onDeactivation.call(this);
    this.input.blur();
  },

  CLASS_NAME :'WPS.Component.Literal'
});