/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 91043 $
 * @requires OpenLayers.js
 */

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 91043 $
 * @requires OpenLayers.js
 */

(function() {
    var singleFile = (typeof LegatoJQuery == "object" && LegatoJQuery.singleFile);
    /**
     * Relative path of this script.
     */
    var scriptName = (!singleFile) ? "lib/LegatoJQuery.js" : "LegatoJQuery.js";
    var jsFiles = window.LegatoJQuery;

    window.LegatoJQuery = {
        _getScriptLocation: (function() {
            var r = new RegExp("(^|(.*?\\/))(" + scriptName + ")(\\?|$)"),
                s = document.getElementsByTagName('script'),
                src, m, l = "";
            for(var i=0, len=s.length; i<len; i++) {
                src = s[i].getAttribute('src');
                if(src) {
                    m = src.match(r);
                    if(m) {
                        l = m[1];
                        break;
                    }
                }
            }
            return (function() { return l; });
        })()
    };

    if(!singleFile) {
      /**
       * PATCH
       */
      //if (!jsFiles) {
      jsFiles = [
       'LegatoJQuery/Control.js',
       'LegatoJQuery/Control/ControlContainer.js',
       'LegatoJQuery/Control/MapResizer.js',
       'LegatoJQuery/Popup.js',
       'LegatoJQuery/Popup/DialogPopup.js',
       'LegatoJQuery/StyleProperties.js',
       'LegatoJQuery/StyleProperties/ColorInputElement.js',
       'LegatoJQuery/StyleProperties/SelectElement.js',
       'LegatoJQuery/StyleProperties/Factory.js'
      ]; // etc.
      /**
       * PATCHJ
       */
      //}

      // use "parser-inserted scripts" for guaranteed execution order
      // http://hsivonen.iki.fi/script-execution/
      var scriptTags = new Array(jsFiles.length);
      var host = LegatoJQuery._getScriptLocation() + "lib/";
      for (var i=0, len=jsFiles.length; i<len; i++) {
          scriptTags[i] = "<script src='" + host + jsFiles[i] +
                                 "'></script>";
      }
      if (scriptTags.length > 0) {
          document.write(scriptTags.join(""));
      }
    }
})();

/**
 * Constant: VERSION_NUMBER
 */
LegatoJQuery.VERSION_NUMBER = "$Revision: 75646 $";
LegatoJQuery.NAMESPACE_URI = 'http://www.disy.net/legatojquery/';
LegatoJQuery.PREFIX = 'ljq';
LegatoJQuery.QName = function(localPart) {
  return new Legato.XML.QName(LegatoJQuery.NAMESPACE_URI, localPart, LegatoJQuery.PREFIX);
};