/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Popup = OpenLayers.Class({

  title: null,

  size: null,

  position: null,

  zIndex: null,

  initialize : function(options) {
    Legato.Util.Ensure.ensureExists(options.title, 'title should be defined');
    OpenLayers.Util.extend(this, options);
  },

  openUrl : function(url) {
    throw new Legato.Lang.Exception(this.CLASS_NAME +
      ' must implement the openUrl function from from abstract class ' +
      Legato.Popup.CLASS_NAME);
  },

  open : function(element) {
    throw new Legato.Lang.Exception(this.CLASS_NAME +
      ' must implement the open function from from abstract class ' +
      Legato.Popup.CLASS_NAME);
  },

  close : function() {
    throw new Legato.Lang.Exception(this.CLASS_NAME +
      ' must implement the close function from from abstract class ' +
      Legato.Popup.CLASS_NAME);
  },

  setPosition: function(position){
    if(!Legato.Lang.ObjectUtils.isNullOrUndefined(position)){
      if((Legato.Lang.ObjectUtils.isNullOrUndefined(this.maintainPosition) ||
          Legato.Lang.ObjectUtils.isFalse(this.maintainPosition))){
          this.position = position;
          this.dialog.dialog( 'option', 'position', [this.position.x, this.position.y] );
      }
    }
  },

  getPosition: function(){
    return this.position;
  },

  CLASS_NAME :'Legato.Popup'
});

/**
 * Space: lpo
 * Namespace for Legato popups.
 */
/**
 * URI: Namespace URI
 * {http://www.disy.net/legato/popup}
 */
Legato.Popup.NAMESPACE_URI = 'http://www.disy.net/legato/popup';
/**
 * Prefix: Default prefix
 * {lpo}
 */
Legato.Popup.PREFIX = 'lpo';

Legato.Popup.QName = function(localPart) {
  return new Legato.XML.QName(Legato.Popup.NAMESPACE_URI, localPart,
      Legato.Popup.PREFIX);
};

/**
 * Component: lpo:Popup
 *
 * Abstract base component for popup components.
 *
 * See also:
 * - <lpo> namespace
 * - <Legato.Popup>
 */
Legato.Popup.Bean = Legato.Beans.Object.Extend('Legato.Popup',
Legato.Popup.QName('Popup'),
//
{
  _constructor : Legato.Popup,
  options : {
    /**
     * Element: title
     * {String} A popup title.
     */
    title: Legato.Lang.String,

    /**
     * Element: size
     * {<OpenLayers.Size>} The initial size of the popup.
     */
    size: OpenLayers.Size,

    /**
     * Element: position
     * {<OpenLayers.Pixel>} The initial position of the popup.
     */
    position: OpenLayers.Pixel,

    /**
     * Element: zIndex
     * {Integer} The zIndex for the popup.
     */
    zIndex: Legato.Lang.Integer,
    
    /**
     * Element: maxHeight
     * {Integer} The maximum allowed height for the popup.
     */
    maxHeight: Legato.Lang.Integer,
    
    /**
     * Element: height
     * {Integer} The initial height of the popup.
     */    
    height: Legato.Lang.Integer,
    
    /**
     * Element: width
     * {Integer} The initial height of the popup.
     */    
    width: Legato.Lang.Integer,
    
    /**
     * Element: maintainPosition
     * {String} Maintain the last position of the popup set by user
     */
    maintainPosition: Legato.Lang.Boolean
  }

});
