/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

var beans = {
  navigationHistory :OpenLayers.Control.NavigationHistory.Bean.define(),
  map :OpenLayers.Map.Bean.define( {
    id :'map',
    maxExtent :OpenLayers.Bounds.Bean.define( {
      left :2,
      bottom :51,
      right :18,
      top :59
    })
    ,
    controls : [
    //
        OpenLayers.Control.ArgParser.Bean.define(), //
        OpenLayers.Control.Attribution.Bean.define(), //
        OpenLayers.Control.LayerSwitcher.Bean.define(), //
        OpenLayers.Control.ScaleLine.Bean.define(), //
        OpenLayers.Control.MousePosition.Bean.define(), //
        OpenLayers.Control.OverviewMap.Bean.define( {
          _div :'overviewMap',
          size :OpenLayers.Size.Bean.define( {
            w :'160',
            h :'80'
          })
        }), //
        $ref('navigationHistory'), //
        $ref('panel')
    //
    ],
    layers : {
      //
      bathymetry :OpenLayers.Layer.WMS.Bean.define( {
        name :'Bathymetry',
        title: 'Bathymetry layers',
        url :'http://www2.demis.nl/wms/wms.asp?wms=WorldMap&',
        params : {
          layers :'Bathymetry,Topography',
          format :'image/png'
        },
        singleTile: true
      }),
      //
      borders :OpenLayers.Layer.WMS.Bean.define( {
        name :'Topography',
        url :'http://www2.demis.nl/wms/wms.asp?wms=WorldMap&',
        params : {
          layers :'Borders',
          transparent :'true',
          format :'image/gif'
        },
        singleTile: true,
        isBaseLayer :'false'
      })
    //
    }
  }),
  mouseDefaults :OpenLayers.Control.MouseDefaults.Bean.define(),
  panel :OpenLayers.Control.Panel.Bean.define( {
    defaultControl :$ref('mouseDefaults'),
    controls : [
    // 
        $ref('mouseDefaults'),// 
        OpenLayers.Control.ZoomToMaxExtent.Bean.define(),//
        OpenLayers.Control.ZoomBox.Bean.define( {
          displayClass :'olControlZoomInBox',
          out :false
        }),// 
        OpenLayers.Control.ZoomBox.Bean.define( {
          displayClass :'olControlZoomOutBox',
          out :true
        }),//
        $ref('navigationHistory').Field('previous'),//
        $ref('navigationHistory').Field('next')
    //
    ]
  })
};
var beanFactory = new Legato.Beans.BeanFactory(beans);