/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

LegatoJQuery.StyleProperties.ColorInputElement = OpenLayers
    .Class(
        Legato.StyleProperties.InputElement,
        {
          createInput : function() {
            var colorInput = Legato.StyleProperties.InputElement.prototype.createInput
                .apply(this, arguments);
            var jColorInput = jQuery(colorInput);
            var that = this;
            jColorInput.colorpicker({
              parts : [ 'map', 'bar', 'rgb', 'alpha', 'swatches', 'preview'],
              select : function(event, color) {
                var propertyValue = '#' + color.formatted;
                that.style[that.propertyName.replace('Color', 'Opacity')]= color.a;
                that.onInputValueChanged(propertyValue);
                that.updateInputElement(jColorInput, propertyValue, color.a);
              },
              open : function(event){
                jColorInput.blur();
              },
              alpha : true
            });
            jColorInput.addClass('StylePropertyColorInput');
            jColorInput.attr('readonly', 'readonly');
            this.updateInputElement(jColorInput, '#' + this.propertyValue, 1);
            return colorInput;
          },
          
          updateInputElement: function(jColorInput, color, opacity){
            jColorInput.css('background', color)
                       .css('border', color)
                       .css('opacity', opacity);
          },

          CLASS_NAME : 'LegatoJQuery.StyleProperties.ColorInputElement'
        });